// ogl03.cxx

// from : http://www.glprogramming.com/red/chapter03.html

#include "ogl02.hxx"
//#include <stdlib.h>
#include <stdio.h>   // for printf()
#include "fps.hxx"   // for output_font_stg(void *font, int x, int y, char *string)

/* *****************************************************
   Figure 3-2 : Stages of Vertex Transformation 


   Vertex x, y, z, w  = Object coordinates
   x = horizonal - longitude
   y = vertical  - latitude
   z = altitude  - default = 0
   w =           - default = 1
   (Remember that the x, y, and z coordinates are eventually
    divided by the w coordinate.)

   ModelView Matrix   = Eye coorodinates
   Projection Matrix  = Clip coordinates
   Perspective Division = normalised device coordinates
   Viewport Tranformations = Window coordinates

   Specifying the projection transformation is like choosing a lens for a camera

NAME
	  gluPerspective - set up a perspective	projection matrix


     C SPECIFICATION
	  void gluPerspective( GLdouble	fovy,
			       GLdouble	aspect,
			       GLdouble	zNear,
			       GLdouble	zFar )


     PARAMETERS
	  fovy	  Specifies the	field of view angle, in	degrees, in
		  the y	direction.

	  aspect  Specifies the	aspect ratio that determines the field
		  of view in the x direction.  The aspect ratio	is the
		  ratio	of x (width) to	y (height).

	  zNear	  Specifies the	distance from the viewer to the	near
		  clipping plane (always positive).

	  zFar	  Specifies the	distance from the viewer to the	far
		  clipping plane (always positive).

     DESCRIPTION
	  gluPerspective specifies a viewing frustum into the world
	  coordinate system.  In general, the aspect ratio in
	  gluPerspective should	match the aspect ratio of the
	  associated viewport. For example, aspect=2.0 means the
	  viewer's angle of view is twice as wide in x as it is	in y.
	  If the viewport is twice as wide as it is tall, it displays
	  the image without distortion.

	  The matrix generated by gluPerspective is multipled by the
	  current matrix, just as if glMultMatrix were called with the
	  generated matrix.  To	load the perspective matrix onto the
	  current matrix stack instead,	precede	the call to
	  gluPerspective with a	call to	glLoadIdentity.

   Drawing the Scene
   Once all the necessary transformations have been specified,
   you can draw the scene (that is, take the photograph). As the 
   scene is drawn, OpenGL transforms each vertex of every object 
   in the scene by the modeling and viewing transformations. 
   Each vertex is then transformed as specified by the projection 
   transformation and clipped if it lies outside the viewing volume 
   described by the projection transformation. 
   Finally, the remaining transformed vertices are divided by w 
   and mapped onto the viewport. 

GLUT_KEY_* are predefined constants in glut.h. The full set of constants is presented next: 


--------------------------------------------------------------------------------

    
GLUT_KEY_F1		F1 function key
GLUT_KEY_F2		F2 function key
GLUT_KEY_F3		F3 function key
GLUT_KEY_F4		F4 function key
GLUT_KEY_F5		F5 function key
GLUT_KEY_F6		F6 function key
GLUT_KEY_F7		F7 function key
GLUT_KEY_F8		F8 function key
GLUT_KEY_F9		F9 function key
GLUT_KEY_F10		F10 function key
GLUT_KEY_F11		F11 function key
GLUT_KEY_F12		F12 function key
GLUT_KEY_LEFT		Left function key
GLUT_KEY_RIGHT		Up function key
GLUT_KEY_UP		Right function key
GLUT_KEY_DOWN		Down function key
GLUT_KEY_PAGE_UP	Page Up function key
GLUT_KEY_PAGE_DOWN	Page Down function key
GLUT_KEY_HOME		Home function key
GLUT_KEY_END		End function key
GLUT_KEY_INSERT		Insert function key


   ****************************************************** */

// Example 3-1 : Transformed Cube: cube.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>

// options
bool use_translate = true;
bool use_solid_cube = false;
bool use_frustrum = false;
static int ms_wait = 55;
bool use_solid_spheres = true;

//	  void gluPerspective( GLdouble	fovy,
//			       GLdouble	aspect,
//			       GLdouble	zNear,
//			       GLdouble	zFar )
// gluPerspective(60.0, 1.0, 1.5, 20.0);

GLdouble fovy = 60.0;   // Specifies the	field of view angle, in	degrees, in
// the y direction. 30.0 will enlarge, 100.0 will decrease
GLdouble aspect = 1.0;  // Specifies the	aspect ratio that determines the field
// of view in the x direction. The aspect ratio is the ratio of x (width) to y (height).
// 0.5 will 'fatten', while 2.0 will narrow the cube
GLdouble zNear	= 1.5;   // Specifies the	distance from the viewer to the	near
// clipping plane (always positive).
GLdouble zFar = 20.0;   // Specifies the	distance from the viewer to the	far
// clipping plane (always positive).

// Show that the following routine could serve as the viewing transformation:

void pilotView(GLdouble planex, GLdouble planey,
               GLdouble planez, GLdouble roll,
               GLdouble pitch, GLdouble heading)
{
      glRotated(roll, 0.0, 0.0, 1.0);  // angle,x,y,z
      glRotated(pitch, 0.0, 1.0, 0.0);  // angle,x,y,z
      glRotated(heading, 1.0, 0.0, 0.0);  // angle,x,y,z
      glTranslated(-planex, -planey, -planez);
}


void init3(void) 
{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_FLAT);
}

void display3(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glLoadIdentity ();             /* clear the matrix */
   if( use_translate ) {
      // moved the cube away from the camera (with a modeling transformation)
      glTranslatef(0.0, 0.0, -5.0);
   } else {
      /* viewing transformation  */
      // moving the camera (with a viewing transformation)
      gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   }
   glScalef (1.0, 2.0, 1.0);      /* modeling transformation */ 
   if( use_solid_cube )
      glutSolidCube (1.0);
   else
      glutWireCube (1.0);

   glFlush ();
}

void reshape3(int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();

   if( use_frustrum )
      glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);
   else
      gluPerspective(fovy, aspect, zNear, zFar); // gluPerspective(60.0, 1.0, 1.5, 20.0);

   glMatrixMode (GL_MODELVIEW);
}

void keyboard3( unsigned char key, int x, int y )
{
   switch (key)
   {
   case 0x1b:
   case 'q':
   case 'Q':
      pgm_exit(0);
      break;
   }
}

int main3(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init3 ();
   glutDisplayFunc(display3); 
   glutReshapeFunc(reshape3);
   glutKeyboardFunc(keyboard3);
   glutMainLoop();
   return 0;
}

// ========================================================

void init35(void) 
{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_FLAT);
}

void display35(void)
{
   GLdouble eqn[4] = {0.0, 1.0, 0.0, 0.0};
   GLdouble eqn2[4] = {1.0, 0.0, 0.0, 0.0};

   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glPushMatrix();
   glTranslatef (0.0, 0.0, -5.0);

/*    clip lower half -- y < 0          */
   glClipPlane (GL_CLIP_PLANE0, eqn);
   glEnable (GL_CLIP_PLANE0);
/*    clip left half -- x < 0           */
   glClipPlane (GL_CLIP_PLANE1, eqn2);
   glEnable (GL_CLIP_PLANE1);

   glRotatef (90.0, 1.0, 0.0, 0.0);  // angle,x,y,z
   glutWireSphere(1.0, 20, 16);
   glPopMatrix();
   glFlush ();
}

void reshape35 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode (GL_MODELVIEW);
}

int main35(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init35 ();
   glutDisplayFunc(display35); 
   glutReshapeFunc(reshape35);
   glutKeyboardFunc(keyboard3);
   glutMainLoop();
   return 0;
}

// **************************************************************

static int year = 0, day = 0;
static bool animate_on = true;

void help_key36(void)
{
   printf( " t   = toggle animation (%s)\n", (animate_on ? "On" : "Off"));
   printf( " +/- = increase/decrease animation speed.\n" );
   printf( "With animation off -\n" );
   printf( " d/D = increase/decrease day\n" );
   printf( " y/Y = increase/decrease year\n" );
   printf( " s   = toggle solid sun. (%s)\n", (use_solid_spheres ? "On" : "Off"));
}

void init36(void) 
{
   help_key36();
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_FLAT);
}

void progression(void)
{
   if(animate_on) {
      day = (day + 10) % 360;
      year = (year + 5) % 360;
   }
}

void display36(void)
{
   if( ms_wait && check_timeout(ms_wait) ) {
      return;
   }
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);

   // Use glPushMatrix and glPopMatrix to save and restore the 
   // unrotated coordinate system. 
   glPushMatrix();
   glColor3f (1.0, 1.0, 0.0);
   if( use_solid_spheres )
      glutSolidSphere(1.0, 20, 16);   /* draw sun */
   else
      glutWireSphere(1.0, 20, 16);   /* draw sun */

   // SETUP TO DRAW THE PLANET
   // ========================
   // glRotatef( GLfloat   angle, GLfloat x, GLfloat y, GLfloat z); 
   // Parameters angle - Specifies the angle of rotation, in degrees.
   // x, y, z - Specify the x, y, and z coordinates of a vector, respectively. 
   // If the matrix mode is either GL_MODELVIEW or GL_PROJECTION,
   // all objects drawn after glRotate is called are rotated. 
   // Notes: This rotation follows the right-hand rule, so if the 
   // vector (x,y,z) points toward the user, the rotation will 
   // be counterclockwise. 
   glRotatef ((GLfloat) year, 0.0, 1.0, 0.0); // pos around SUN - angle,x,y,z
   glTranslatef (2.0, 0.0, 0.0);
   glRotatef ((GLfloat) day, 0.0, 1.0, 0.0); // planet rotation - angle,x,y,z

   glColor3f (0.75, 0.0, 0.75);
   // void glutWireSphere  ( GLdouble radius , GLint slices , GLint stacks ); 
   // Parameters
   // radius  = The radius of the sphere. 
   // slices  = The number of subdivisions around the Z axis 
   //           (similar to lines of longitude). 
   // stacks  = The number of subdivisions along the Z axis
   //           (similar to lines of latitude). 
   glutWireSphere(0.2, 10, 8);    /* draw smaller planet */

   glPopMatrix();

   glutSwapBuffers();
   progression();
}

void reshape36 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void keyboard36 (unsigned char key, int x, int y)
{
   keyboard3( key, x, y );
   switch (key) {
      case 'h':
      case '?':
         help_key36();
         break;
      case 'd':
         day = (day + 10) % 360;
         glutPostRedisplay();
         break;
      case 'D':
         day = (day - 10) % 360;
         glutPostRedisplay();
         break;
      case 'y':
         year = (year + 5) % 360;
         glutPostRedisplay();
         break;
      case 'Y':
         year = (year - 5) % 360;
         glutPostRedisplay();
         break;
      case 't':
         animate_on = !animate_on;
         printf( "t - toggle animation (%s)\n", (animate_on ? "On" : "Off"));
         if(animate_on)
            glutIdleFunc(display36);
         else
            glutIdleFunc(NULL); 
         break;
      case '+':
         if( ms_wait )
            ms_wait--;
         break;
      case '-':
         ms_wait++;
         break;

      case 's':
         use_solid_spheres = !use_solid_spheres;
         printf("s - toggle solid sun. (%s)\n", (use_solid_spheres ? "On" : "Off"));
         if(!animate_on)
            glutPostRedisplay();
         break;

      default:
         break;
   }
}

//   case 4:
//      printf("  4: main36(argc,argv);  // planet around sun... slowed\n" );
int main36(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init36 ();
   glutDisplayFunc(display36); 
   glutIdleFunc(display36); 
   glutReshapeFunc(reshape36);
   glutKeyboardFunc(keyboard36);
   glutMainLoop();
   return 0;
}

// =========================================
// from : http://www.lighthouse3d.com/opengl/glut/index.php?5

// all variables initialized to 1.0, meaning 
// the triangle will initially be white
static float red=1.0, blue=1.0, green=1.0;
static float angle = 0.0;

static void
help_keys_05(void)
{
   printf( " h/? - this help\n" );
   printf( " F1  - set RED\n" );
   printf( " F2  - set GREEN\n" );
   printf( " F3  - set BLUE\n" );
   printf( " r   - reset WHITE\n" );
   printf( " +/- - increase/decrease rotation speed.\n" );
   printf( " ESC - exit.\n" );
}

static void
processNormalKeys(unsigned char key, int x, int y) {
   keyboard_pgm_exit(key,x,y);
   switch(key)
   {
   case 'h':
   case '?':
      help_keys_05();
      break;
   case 'r':
      red = 1.0; 
		green = 1.0; 
		blue = 1.0;
      break;
   case '+':
      if(ms_wait)
         ms_wait--;
      break;
   case '-':
      ms_wait++;
      break;
   }
}

static void
processSpecialKeys(int key, int x, int y) {

	switch(key) {
		case GLUT_KEY_F1 : 
				red = 1.0; 
				green = 0.0; 
				blue = 0.0; break;
		case GLUT_KEY_F2 : 
				red = 0.0; 
				green = 1.0; 
				blue = 0.0; break;
		case GLUT_KEY_F3 : 
				red = 0.0; 
				green = 0.0; 
				blue = 1.0; break;
	}
}

static void
renderScene(void) {

   if( ms_wait && check_timeout(ms_wait) )
      return;

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glPushMatrix();
	glRotatef(angle,0.0,1.0,0.0);  // angle,x,y,z

	// this is where we set the actual color
	// glColor specifies the color of all further drawings
	glColor3f(red,green,blue);

	glBegin(GL_TRIANGLES);
		glVertex3f(-0.5,-0.5,0.0);
		glVertex3f(0.5,0.0,0.0);
		glVertex3f(0.0,0.5,0.0);
	glEnd();

	glPopMatrix();
	angle++;
	glutSwapBuffers();
}

static void
changeSize(int w, int h) {

	// Prevent a divide by zero, when window is too short
	// (you can't make a window of zero width).
	if(h == 0)
		h = 1;

	float ratio = 1.0* w / h;

	// Reset the coordinate system before modifying
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	
	// Set the viewport to be the entire window
	glViewport(0, 0, w, h);

	// Set the correct perspective.
	gluPerspective(45,ratio,1,1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0,0.0,5.0, 
		      0.0,0.0,-1.0,
			  0.0f,1.0f,0.0f);

}

//   case 5:
//    printf("  5: main_dbl_tris(argc, argv); // rotating triangle - slowed to 55ms\n" );
int main_dbl_tris(int argc, char **argv)
{
	glutInit(&argc, argv);
	
	// This is where we say that we want a double buffer
	glutInitDisplayMode(GLUT_DEPTH|GLUT_DOUBLE|GLUT_RGBA);
	
	glutInitWindowPosition(100,100);
	glutInitWindowSize(320,320);
	glutCreateWindow("GLUT Tutorial - 3D Tech");
	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);
	glutReshapeFunc(changeSize);
	
	// here are the new entries
	glutKeyboardFunc(processNormalKeys);
	glutSpecialFunc(processSpecialKeys);	

	// enable depth testing
	glEnable(GL_DEPTH_TEST);
   help_keys_05();

	glutMainLoop();
   return 0;
}


// =========================================

static int shoulder = 0, elbow = 0;

static void init37(void) 
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glShadeModel (GL_FLAT);
}

static void display37(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   glPushMatrix();
   glTranslatef (-1.0, 0.0, 0.0);
   glRotatef ((GLfloat) shoulder, 0.0, 0.0, 1.0);  // angle,x,y,z
   glTranslatef (1.0, 0.0, 0.0);
   glPushMatrix();
   glScalef (2.0, 0.4, 1.0);
   glutWireCube (1.0);
   glPopMatrix();

   glTranslatef (1.0, 0.0, 0.0);
   glRotatef ((GLfloat) elbow, 0.0, 0.0, 1.0);  // angle,x,y,z
   glTranslatef (1.0, 0.0, 0.0);
   glPushMatrix();
   glScalef (2.0, 0.4, 1.0);
   glutWireCube (1.0);
   glPopMatrix();

   glPopMatrix();
   glutSwapBuffers();
}

static void reshape37 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective(65.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef (0.0, 0.0, -5.0);
}

static void key_help37(void)
{
   printf( " h/?   - this help\n" );
   printf( " s/S   - rotate at shoulder (%d)\n", shoulder );
   printf( " e/E   - rotate at elbow (%d)\n", elbow );
   printf( " r/R   - reset.\n" );
   printf( " ESC/q - exit.\n" );
}

static void keyboard37 (unsigned char key, int x, int y)
{
   keyboard3(key,x,y);
   switch (key) {
      case 'h':
      case '?':
         key_help37();
         break;
      case 'r':
      case 'R':
         shoulder = elbow = 0;
         glutPostRedisplay();
         break;
      case 's':   /*  s key rotates at shoulder  */
         shoulder = (shoulder + 5) % 360;
         glutPostRedisplay();
         break;
      case 'S':
         shoulder = (shoulder - 5) % 360;
         glutPostRedisplay();
         break;
      case 'e':  /*  e key rotates at elbow  */
         elbow = (elbow + 5) % 360;
         glutPostRedisplay();
         break;
      case 'E':
         elbow = (elbow - 5) % 360;
         glutPostRedisplay();
         break;
      default:
         break;
   }
}

//   case 6:
//    printf("  6: main37(argc,argv);  // animated (very simple) arm\n" );
int main37(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init37 ();
   glutDisplayFunc(display37); 
   glutReshapeFunc(reshape37);
   glutKeyboardFunc(keyboard37);
   key_help37();
   glutMainLoop();
   return 0;
}

// ==========================================
// *******************************************************************
// -------------------------------------------------------------------

#define MX_LINES  60
static int max_lines = MX_LINES;
static char coord_text[MX_LINES][128];
static int next_line = 0;
static int begin_line = 0;
static void * fixedFont = GLUT_BITMAP_TIMES_ROMAN_10;
static GLfloat top = 15.0;

#define  bumpLine(a)   a++; if(a >= max_lines) a = 0

static void
drawStatus38( void )
{
   int i, yell[3];
   char * cp;
	GLsizei winWidth, winHeight;
   //GLfloat top = 15.0;
   //GLfloat skip = 20.0;
   GLfloat skip = glutBitmapHeight(fixedFont);
   GLfloat left = 10.0;
   GLfloat bottom = 15.0;

	/* save the ModelView matrix */
	glPushMatrix(); 

	/* clear any current modeling or viewing xforms */
	glLoadIdentity(); 


	/* save the Projection matrix */
	glMatrixMode( GL_PROJECTION );
	glPushMatrix();

		/* make new world space to display status in */
		glLoadIdentity();
		winWidth = glutGet(GLUT_WINDOW_WIDTH); 
		winHeight = glutGet(GLUT_WINDOW_HEIGHT);
		glOrtho( -0.5, winWidth-0.5, -0.5, winHeight-0.5, -1, 1.0 );

		glPushAttrib( GL_DEPTH_BUFFER_BIT );
	
			/* don't want text to be hidden */
			glDisable( GL_DEPTH_TEST ); 

			glColor3f( 1.0f, 1.0f, 1.0f );

         // setup for 3 yellow colored lines
         i = begin_line;
         yell[0] = i;
         bumpLine(i);
         yell[1] = i;
         bumpLine(i);
         yell[2] = i;

         // paint the lines available
         for( i = 0; i < max_lines; i++ ) {
            cp = &coord_text[i][0];
            if(*cp) {
               if(( i == yell[0] )||( i == yell[1] )||( i == yell[2] ))
         			glColor3f( 1.0f, 1.0f, 0.0f );
               output_font_stg(fixedFont,
                  10,
                  (int)(winHeight-(top + (skip * i))),
                  cp);
               if(( i == yell[0] )||( i == yell[1] )||( i == yell[2] ))
         			glColor3f( 1.0f, 1.0f, 1.0f );
            }
         }

		glPopAttrib();

	/* restore matrixes */
	glPopMatrix();

	glMatrixMode( GL_MODELVIEW );
	glPopMatrix();
} /* drawStatus38 */


static void display38(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glLoadIdentity();
   drawStatus38();
   glFlush();
}

static void reshape38(int w, int h)
{
   g_width = w;
   g_height = h;
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective (45.0, (GLfloat) w/(GLfloat) h, 1.0, 100.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

   // how many lines will fit this height?
   max_lines = (h / glutBitmapHeight(fixedFont));   // integer math
   if(max_lines > MX_LINES) max_lines = MX_LINES;
}

static void mouse38(int button, int state, int x, int y) 
{
   GLint viewport[4];
   GLdouble mvmatrix[16], projmatrix[16];
   GLint realy;  /*  OpenGL y coordinate position  */
   GLdouble wx, wy, wz;  /*  returned world x, y, z coords  */
   char * cp;
   switch (button) {
      case GLUT_LEFT_BUTTON:
         if (state == GLUT_DOWN) {
            glGetIntegerv (GL_VIEWPORT, viewport);
            glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);
            glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);

            begin_line = next_line;
            // 1
            cp = &coord_text[next_line][0];
            /*  note viewport[3] is height of window in pixels  */
            realy = viewport[3] - (GLint) y - 1;
            sprintf (cp, "Coordinates at cursor are (%4d, %4d)", 
               x, realy);
            bumpLine(next_line);

            // 2
            gluUnProject ((GLdouble) x, (GLdouble) realy, 0.0,
               mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
            cp = &coord_text[next_line][0];
            sprintf (cp, "World coords at z=0.0 are (%f, %f, %f)",
               wx, wy, wz);
            printf("%s\n", cp);
            bumpLine(next_line);

            // 3
            gluUnProject ((GLdouble) x, (GLdouble) realy, 1.0,
               mvmatrix, projmatrix, viewport, &wx, &wy, &wz);
            cp = &coord_text[next_line][0];
            sprintf (cp, "World coords at z=1.0 are (%f, %f, %f)",     
               wx, wy, wz);
            printf("%s\n", cp);
            bumpLine(next_line);

#if 0    // have now changed the color of the current 3, so NO
            // clear the next 3 lines
            int j = next_line;
            for(int i = 0; i < 3; i++) {
               cp = &coord_text[j][0];
               *cp = 0; // clear the NEXT
               bumpLine(j);
            }
#endif // 0

            glutPostRedisplay();
         }
         break;
      case GLUT_RIGHT_BUTTON:
         if (state == GLUT_DOWN)
            pgm_exit(0);
         break;
      default:
         break;
   }
}

static void
init38(void)
{
   for(int i = 0; i < MX_LINES; i++) {
      char * cp = &coord_text[i][0];
      *cp =0;
   }
   glMatrixMode(GL_PROJECTION);
   gluOrtho2D( 0.0, 500.0, 500.0, 0.0 );
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

int main38(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   glutDisplayFunc(display38); 
   glutReshapeFunc(reshape38); 
   glutKeyboardFunc(keyboard3);
   glutMouseFunc(mouse38);
   printf("Left click shows coordinates. Right click exits, as does ESC/q/Q...\n");
   init38();
   glutMainLoop();
   return 0;
}


// ==========================================
// eof - ogl03.cxx
