// ogl04.cxx

#include "ogl02.hxx"

void init41(void) 
{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_SMOOTH);
}

void triangle41(void)
{
   glBegin (GL_TRIANGLES);

      // with GL_SMOOTH, this color will be applied 'smoothly'
      // to the figure, from this vertex, towards the others
      glColor3f (1.0, 0.0, 0.0); // RED
      glVertex2f (5.0, 5.0);
      // but since this vertex changes color, it will be applied
      // smoothly, towards the others, with a blend inbetween...
      glColor3f (0.0, 1.0, 0.0); // GREEN
      glVertex2f (25.0, 5.0);
      // like wise...
      glColor3f (0.0, 0.0, 1.0); // BLUE
      glVertex2f (5.0, 25.0);

   glEnd();
}

void display41(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   triangle41 ();
   glFlush ();
}

void reshape41 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   if (w <= h)
      gluOrtho2D (0.0, 30.0, 0.0, 30.0*(GLfloat) h/(GLfloat) w);
   else
      gluOrtho2D (0.0, 30.0*(GLfloat) w/(GLfloat) h, 0.0, 30.0);
   glMatrixMode(GL_MODELVIEW);
}

void keyboard4( unsigned char key, int x, int y )
{
   switch (key)
   {
   case 0x1b:
   case 'q':
   case 'Q':
      pgm_exit(0);
      break;
   }
}

//   case 8:
//     return main41(argc,argv);  // smooth shaded color triangle
int main41(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init41 ();
   glutDisplayFunc(display41); 
   glutReshapeFunc(reshape41);
   glutKeyboardFunc(keyboard4);
   glutMainLoop();
   return 0;
}

// eof - ogl04.cxx
