// ogl05.cxx

#include "ogl02.hxx"
#include "ogl05.hxx"

static bool use_double_buffer51 = true;
static GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };
static bool do_animate51 = true;

static void set_light_position51(int show)
{
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   if(show) {
      printf("light_position(x=%0.3f,y=%0.3f,z=%0.3f\n",
         light_position[0],
         light_position[1],
         light_position[2] );
   }
}

void init51(void) 
{
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat mat_shininess[] = { 50.0 };
   glClearColor (0.0, 1.0, 0.0, 0.0);  // green background

   glShadeModel (GL_SMOOTH);

   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);

   printf("Initial: ");
   set_light_position51(1);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_DEPTH_TEST);
}

void display51(void)
{
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glutSolidSphere (1.0, 20, 16);
   if(use_double_buffer51)
      glutSwapBuffers();
   else
      glFlush ();
}

void reshape51 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,
         1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
   else
      glOrtho (-1.5*(GLfloat)w/(GLfloat)h,
         1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

static void key_help51(void)
{
   printf(" h/?    - this help.\n");
   printf(" l      - move light source\n" );
   printf(" a      - animate light source\n" );
   printf(" ESC/q  - exit.\n" );
}

static void
new_light_source51(GLfloat ladj, int show)
{
   if(( light_position[0] > -1.0 ) && ( light_position[1] == 1.0 )) {
      light_position[0] -= ladj;
      if( light_position[0] < -1.0 )
         light_position[0] = -1.0;
      if(show)
         printf("l -[0]: " );
   } else if (( light_position[1] > -1.0 )&&( light_position[0] <= -1.0 )) {
      light_position[1] -= ladj;
      if( light_position[1] < -1.0 )
         light_position[1] = -1.0;
      if(show)
         printf("l -[1]: " );
   } else if (( light_position[1] <= -1.0 )&&( light_position[0] < 1.0 )) {
      light_position[0] += ladj;
      if( light_position[0] > 1.0 )
         light_position[0] = 1.0;
      if(show)
         printf("l +[0]: " );
   } else {
      light_position[1] += ladj;
      if( light_position[1] > 1.0 )
         light_position[1] = 1.0;
      if(show)
         printf("l +[1]: " );
   }
   set_light_position51(show);
   glutPostRedisplay();
}

static void
keyboard51( unsigned char key, int x, int y )
{
   GLfloat ladj = 0.1;
   keyboard_pgm_exit(key,x,y);
   switch (key)
   {
   case 'h':
   case '?':
      key_help51();
      break;
   case 'l':
      new_light_source51(ladj, 1);
      break;
   case 'a':
      do_animate51 = !do_animate51;
      printf("a - toggle animation (now %s)\n",
         (do_animate51 ? "On" : "Off") );
      break;
   }
}

static void
idle51(void)
{
   if(do_animate51) {
      new_light_source51(0.003, 0);
   }
}

//   case 9:
//      return main51(argc,argv);  // lit (grey) sphere
int main51(int argc, char** argv)
{
   glutInit(&argc, argv);
   if(use_double_buffer51)
      glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   else
      glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init51 ();
   glutDisplayFunc(display51); 
   glutReshapeFunc(reshape51);
   glutKeyboardFunc(keyboard51);
   glutIdleFunc(idle51);
   key_help51();
   glutMainLoop();
   return 0;
}

// =====================================================
// Example 5-6 : Moving a Light with Modeling Transformations: movelight.c

//#include <GL/gl.h>
//#include <GL/glu.h>
//#include "glut.h"

static int spin56 = 0;
static bool continuous = false;
static bool use_double_buff = true;

void init56(void) 
{
   //glClearColor (0.0, 0.0, 0.0, 0.0);
   glClearColor (0.2, 0.2, 0.2, 0.0);
   glShadeModel (GL_SMOOTH);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_DEPTH_TEST);
}

/*  Here is where the light position is reset after the modeling
 *  transformation (glRotated) is called.  This places the
 *  light at a new position in world coordinates.  The cube
 *  represents the position of the light.
 */
void display56(void)
{
   GLfloat position[] = { 0.0, 0.0, 1.5, 1.0 };

   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glPushMatrix ();
      glTranslatef (0.0, 0.0, -5.0);

      glPushMatrix ();
         // rotate per degrees spin, 0-360...
         // apply the 'spin' to the lighting position, and cube/sphere
         glRotated ((GLdouble) spin56, 1.0, 0.0, 0.0);  // angle,x,y,z
         glLightfv (GL_LIGHT0, GL_POSITION, position);
         glTranslated (0.0, 0.0, 1.5);

         glDisable (GL_LIGHTING);
         glColor3f (1.0, 1.0, 0.0); // yellow
         //glutWireCube (0.1);
         //glutSolidCube (0.1);
         glutSolidSphere( 0.1, 10, 10 ); // colored sun ;=))
         glEnable (GL_LIGHTING);

      glPopMatrix ();

      // now put the lighted TORUS
      //glutSolidTorus (0.275, 0.85, 8, 15); // innerRad,outerRad,nsides,rings
      glutSolidTorus (0.275, 0.85, 18, 25);  // increase slices - better smooth
   glPopMatrix ();

   if(use_double_buff)
     	glutSwapBuffers();
   else
      glFlush ();
}

static int ms_wait = 55;
static void
render56(void)
{
   if( check_timeout( ms_wait ) )
      return;

   //spin = (spin + 30) % 360;
   spin56 = (spin56 + 5) % 360;
   display56();
}


void reshape56 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(40.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void mouse56(int button, int state, int x, int y)
{
   switch (button) {
      case GLUT_LEFT_BUTTON:
         if (state == GLUT_DOWN) {
            spin56 = (spin56 + 30) % 360;
            glutPostRedisplay();
         }
         break;
      default:
         break;
   }
}

static void
key_help56(void)
{
   printf(" h/? - this help\n" );
   printf(" c/C - toggle continuous = %s\n", (continuous ? "true" : "false") );
   printf(" left mouse click moves light source\n" );
   printf(" ESC/q - exit\n" );
}

void keyboard56( unsigned char key, int x, int y )
{
   keyboard_pgm_exit(key,x,y);
   switch (key)
   {
   case 'h':
   case '?':
      key_help56();
      break;
   case 'c':
   case 'C':
      continuous = !continuous;
      printf("c - continuous = %s\n", (continuous ? "true" : "false") );
      if(continuous)
         glutIdleFunc(render56);
      else
         glutIdleFunc(NULL);
      break;
   }
}


//   case 10:
//      return main56(argc,argv); // torus, with moving light source - left click
//   // c key to make it continuous, with light moving around the torus...
int main56(int argc, char** argv)
{
   glutInit(&argc, argv);
   if( use_double_buff )
      glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   else
      glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init56 ();
   glutDisplayFunc(display56); 
   glutReshapeFunc(reshape56);
   glutMouseFunc(mouse56);
   glutKeyboardFunc(keyboard56);
   key_help56();
   glutMainLoop();
   return 0;
}

// *************************************************************
// Example 5-9 : Using glColorMaterial(): colormat.c
// #include <GL/gl.h>
// #include <GL/glu.h>
// #include "glut.h"

static GLfloat diffuseMaterial[4] = { 0.5, 0.5, 0.5, 1.0 };

void init59(void) 
{
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };

   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_SMOOTH);
   glEnable(GL_DEPTH_TEST);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

   glColorMaterial(GL_FRONT, GL_DIFFUSE);
   glEnable(GL_COLOR_MATERIAL);
}

void display59(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glutSolidSphere(1.0, 20, 16);
   if(use_double_buff)
     	glutSwapBuffers();
   else
      glFlush ();
}

void reshape59 (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,
         1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
   else
      glOrtho (-1.5*(GLfloat)w/(GLfloat)h,
         1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

static void
mouse_click_help(void)
{
   printf(" h/? - this help\n" );
   printf(" +/- - increase/decrease diffused Material\n" );
   printf(" Left click - RED shift\n");
   printf(" Middle click - GREEN shift\n");
   printf(" Right click - BLUE shift\n");
   printf(" ESC/q = exit.\n" );
}

void mouse59(int button, int state, int x, int y)
{
   switch (button) {
      case GLUT_LEFT_BUTTON:
         if (state == GLUT_DOWN) {       /*  change red  */
            printf( "RED shift...\n" );
            diffuseMaterial[0] += 0.1;
            if (diffuseMaterial[0] > 1.0)
               diffuseMaterial[0] = 0.0;
            glColor4fv(diffuseMaterial);
            glutPostRedisplay();
         }
         break;
      case GLUT_MIDDLE_BUTTON:
         if (state == GLUT_DOWN) {       /*  change green  */
            printf( "GREEN shift...\n" );
            diffuseMaterial[1] += 0.1;
            if (diffuseMaterial[1] > 1.0)
               diffuseMaterial[1] = 0.0;
            glColor4fv(diffuseMaterial);
            glutPostRedisplay();
         }
         break;
      case GLUT_RIGHT_BUTTON:
         if (state == GLUT_DOWN) {      /*  change blue  */
            printf( "BLUE shift...\n" );
            diffuseMaterial[2] += 0.1;
            if (diffuseMaterial[2] > 1.0)
               diffuseMaterial[2] = 0.0;
            glColor4fv(diffuseMaterial);
            glutPostRedisplay();
         }
         break;
      default:
         break;
   }
}

static void
keyboard59(unsigned char key, int x, int y)
{
   int i;
   keyboard_pgm_exit(key,x,y);
   switch(key)
   {
   case '+':
      for(i = 0; i < 3; i++) {
         if( diffuseMaterial[i] != 1.0 )
            break;
      }
      if( i < 3 ) {
         for(i = 0; i < 3; i++) {
            diffuseMaterial[i] += 0.1;
            if (diffuseMaterial[i] > 1.0)
               diffuseMaterial[i] = 1.0;
         }
         printf( "diffuseMaterial %0.1f,%0.1f.%0.1f\n",
            diffuseMaterial[0],
            diffuseMaterial[1],
            diffuseMaterial[2] );
         glColor4fv(diffuseMaterial);
         glutPostRedisplay();
      } else {
         printf( "diffuseMaterial %0.1f,%0.1f.%0.1f - at MAXIMUM\n",
            diffuseMaterial[0],
            diffuseMaterial[1],
            diffuseMaterial[2] );
      }
      break;
   case '-':
      for(i = 0; i < 3; i++) {
         if( diffuseMaterial[i] != 0.0 )
            break;
      }
      if(i < 3) {
         for(i = 0; i < 3; i++) {
            diffuseMaterial[i] -= 0.1;
            if (diffuseMaterial[i] < 0.0)
               diffuseMaterial[i] = 0.0;
         }
         printf( "diffuseMaterial %0.1f,%0.1f.%0.1f\n",
            diffuseMaterial[0],
            diffuseMaterial[1],
            diffuseMaterial[2] );
         glColor4fv(diffuseMaterial);
         glutPostRedisplay();
      } else {
         printf( "diffuseMaterial %0.1f,%0.1f.%0.1f at MINIMUM\n",
            diffuseMaterial[0],
            diffuseMaterial[1],
            diffuseMaterial[2] );
      }
      break;
   case 'h':
   case '?':
      mouse_click_help();
      break;
   }
}

//   case 11:
//     return main59(argc, argv); // lit sphere, color change on mouse clicks
// very similar to case 9: return main51(argc,argv);  // lit (grey) sphere
int main59(int argc, char** argv)
{
   glutInit(&argc, argv);
   if( use_double_buff )
      glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   else
      glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init59 ();
   glutDisplayFunc(display59); 
   glutReshapeFunc(reshape59);
   glutMouseFunc(mouse59);
   glutKeyboardFunc(keyboard59);
   mouse_click_help();
   glutMainLoop();
   return 0;
}




// eof - ogl05.cxx
