// ogl06.cxx
#include "ogl02.hxx"
//Example 6-1 : Blending Example: alpha.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
#include <stdlib.h>

static bool use_double_buff = true;
static int leftFirst = GL_TRUE;
static int ms_wait = 65;

/*  Initialize alpha blending function.  */
static void init61(void)
{
   glEnable (GL_BLEND);
   glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
   glShadeModel (GL_FLAT);
   glClearColor (0.0, 0.0, 0.0, 0.0);
}

static void drawLeftTriangle(void)
{
   /* draw yellow triangle on LHS of screen */
   glBegin (GL_TRIANGLES);
      glColor4f(1.0, 1.0, 0.0, 0.75);
      glVertex3f(0.1, 0.9, 0.0); 
      glVertex3f(0.1, 0.1, 0.0); 
      glVertex3f(0.7, 0.5, 0.0); 
   glEnd();
}


static void drawRightTriangle(void)
{
   /* draw cyan triangle on RHS of screen */
   glBegin (GL_TRIANGLES);
      glColor4f(0.0, 1.0, 1.0, 0.75);
      glVertex3f(0.9, 0.9, 0.0); 
      glVertex3f(0.3, 0.5, 0.0); 
      glVertex3f(0.9, 0.1, 0.0); 
   glEnd();
}

void display61(void)
{
   glClear(GL_COLOR_BUFFER_BIT);

   if (leftFirst) {
      drawLeftTriangle();
      drawRightTriangle();
   } else {
      drawRightTriangle();
      drawLeftTriangle();
   }
   glFlush();
}

void reshape61(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h) 
      gluOrtho2D (0.0, 1.0, 0.0, 1.0*(GLfloat)h/(GLfloat)w);
   else 
      gluOrtho2D (0.0, 1.0*(GLfloat)w/(GLfloat)h, 0.0, 1.0);
}

void key_help61(void)
{
   printf( " h/? - this help.\n" );
   printf( " t   - toggle left first - now %s\n", (leftFirst ? "Yes" : "No") );
   printf( " ESC/q - exit.\n" );
}

void keyboard61(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'h':
      case '?':
         key_help61();
         break;
      case 't':
      case 'T':
         leftFirst = !leftFirst;
         printf( "t toggle left first - now %s\n", (leftFirst ? "Yes" : "No") );
         glutPostRedisplay();   
         break;
      default:
         break;
   }
}

//   case 12:
//      return main61(argc, argv); // simple colored triangles, with an overlap -
//      // t toggle which is drawn first, changing the 'blended' overlap area color
int main61(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (200, 200);
   glutCreateWindow (argv[0]);
   init61();
   glutReshapeFunc (reshape61);
   glutKeyboardFunc (keyboard61);
   glutDisplayFunc (display61);
   key_help61();
   glutMainLoop();
   return 0;
}

// =========================================================
// Example 6-2 : Three-Dimensional Blending: alpha3D.c

#include <stdlib.h>
#include <stdio.h>
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>

#define MAXZ 8.0
#define MINZ -8.0
#define ZINC 0.4
static float solidZ = MAXZ;
static float transparentZ = MINZ;
static GLuint sphereList, cubeList;

static void init62(void)
{
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 0.15 };
   GLfloat mat_shininess[] = { 100.0 };
   GLfloat position[] = { 0.5, 0.5, 1.0, 0.0 };

   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
   glLightfv(GL_LIGHT0, GL_POSITION, position);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_DEPTH_TEST);

   sphereList = glGenLists(1);
   glNewList(sphereList, GL_COMPILE);
      glutSolidSphere (0.4, 16, 16);
   glEndList();

   cubeList = glGenLists(1);
   glNewList(cubeList, GL_COMPILE);
      glutSolidCube (0.6);
   glEndList();
}

void display62(void)
{
   GLfloat mat_solid[] = { 0.75, 0.75, 0.0, 1.0 };
   GLfloat mat_zero[] = { 0.0, 0.0, 0.0, 1.0 };
   GLfloat mat_transparent[] = { 0.0, 0.8, 0.8, 0.6 };
   GLfloat mat_emission[] = { 0.0, 0.3, 0.3, 0.6 };

   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   glPushMatrix ();
      // using the (changing) solidZ
      glTranslatef (-0.15, -0.15, solidZ);
      glMaterialfv(GL_FRONT, GL_EMISSION, mat_zero);
      glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_solid);
      glCallList (sphereList);
   glPopMatrix ();

   glPushMatrix ();
      // using the (changing) transparentZ
      glTranslatef (0.15, 0.15, transparentZ);
      glRotatef (15.0, 1.0, 1.0, 0.0);  // angle,x,y,z
      glRotatef (30.0, 0.0, 1.0, 0.0);  // angle,x,y,z
      glMaterialfv(GL_FRONT, GL_EMISSION, mat_emission);
      glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_transparent);
      glEnable (GL_BLEND);
      glDepthMask (GL_FALSE);
      glBlendFunc (GL_SRC_ALPHA, GL_ONE);
      glCallList (cubeList);
      glDepthMask (GL_TRUE);
      glDisable (GL_BLEND);
   glPopMatrix ();

   glutSwapBuffers();
}

void reshape62(int w, int h)
{
   glViewport(0, 0, (GLint) w, (GLint) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,
             1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
   else
      glOrtho (-1.5*(GLfloat)w/(GLfloat)h,
             1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void animate62(void)
{
   if( ms_wait && check_timeout( ms_wait ) )
      return;
   if (solidZ <= MINZ || transparentZ >= MAXZ) {
      printf("End animation - reset values\n");
      //glutIdleFunc(NULL);
      solidZ = MAXZ;
      transparentZ = MINZ;
      printf("reset values solid=%f, trans=%f\n", solidZ, transparentZ);
   } else {
      solidZ -= ZINC;
      transparentZ += ZINC;
      printf("next  values solid=%f, trans=%f\n", solidZ, transparentZ);
   }
   glutPostRedisplay();
}

static void
key_help62(void)
{
   printf( " h/?   - this help.\n" );
   printf( " a/A   - start inimation\n" );
   printf( " s/S   - stop animation\n" );
   printf( " r/R   - stop animation, and reset\n" );
   printf( " +/-   - increase/decrease animation speed\n" );
   printf( " ESC/q - exit.\n" );
}

void keyboard62(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'a':
      case 'A':
         solidZ = MAXZ;
         transparentZ = MINZ;
         printf("Start animation - solidZ=%f transparent=%f\n", solidZ, transparentZ);
         glutIdleFunc(animate62);
         break;
      case 'r':
      case 'R':
         solidZ = MAXZ;
         transparentZ = MINZ;
         printf("Stop Animation and Reset\n");
         glutIdleFunc(NULL);
         glutPostRedisplay();
         break;
      case 's':
      case 'S':
         printf("Stop Animation!\n");
         glutIdleFunc(NULL);
         break;
      case '+':
         if( ms_wait > 1 )
            ms_wait--;
         break;
      case '-':
         ms_wait++;
         break;
      case 'h':
      case '?':
         key_help62();
         break;
    }
}

//   case 13:
//      return main62(argc, argv); // sphere in front of cube - a will decrease
//   // solidZ of shpere, and increase tranparency of cube, or vv ;=))
int main62(int argc, char** argv)
{
   glutInit(&argc, argv);
   if( use_double_buff )
      glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   else
      glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500, 500);
   glutCreateWindow(argv[0]);
   init62();
   glutReshapeFunc(reshape62);
   glutKeyboardFunc(keyboard62);
   glutDisplayFunc(display62);
   key_help62();
   glutMainLoop();
   return 0;
}

// **************************************************************
//Example 6-3 : Antialiased lines: aargb.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <stdio.h>

static float rotAngle = 0.0;

/*  Initialize antialiasing for RGBA mode, including alpha
 *  blending, hint, and line width.  Print out implementation
 *  specific info on line width granularity and width.
 */
static void
init63(void)
{
   GLfloat values[2];
   glGetFloatv (GL_LINE_WIDTH_GRANULARITY, values);
   printf ("GL_LINE_WIDTH_GRANULARITY value is %3.1f\n",
      values[0]);
   glGetFloatv (GL_LINE_WIDTH_RANGE, values);
   printf ("GL_LINE_WIDTH_RANGE values are %3.1f %3.1f\n",
      values[0], values[1]);

   glEnable (GL_LINE_SMOOTH);
   glEnable (GL_BLEND);
   glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
   glHint (GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
   glLineWidth (1.5);

   glClearColor(0.0, 0.0, 0.0, 0.0);
}

/* Draw 2 diagonal lines to form an X */
static void 
display63(void)
{
   glClear(GL_COLOR_BUFFER_BIT);

   glColor3f (0.0, 1.0, 0.0);    // GREEN LINE
   glPushMatrix();
      glRotatef(-rotAngle, 0.0, 0.0, 0.1);  // angle,x,y,z
      glBegin (GL_LINES);
         glVertex2f (-0.5, 0.5);
         glVertex2f (0.5, -0.5);
      glEnd ();
   glPopMatrix();

   glColor3f (0.0, 0.0, 1.0);    // BLUE LINE
   glPushMatrix();
      glRotatef(rotAngle, 0.0, 0.0, 0.1);  // angle,x,y,z
      glBegin (GL_LINES);
         glVertex2f (0.5, 0.5);
         glVertex2f (-0.5, -0.5);
      glEnd ();
   glPopMatrix();

   glFlush();
}

static void 
reshape63(int w, int h)
{
   glViewport(0, 0, (GLint) w, (GLint) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h) 
      gluOrtho2D (-1.0, 1.0, 
         -1.0*(GLfloat)h/(GLfloat)w, 1.0*(GLfloat)h/(GLfloat)w);
   else 
      gluOrtho2D (-1.0*(GLfloat)w/(GLfloat)h, 
         1.0*(GLfloat)w/(GLfloat)h, -1.0, 1.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

static bool animate_on = false;

static void
key_help63(void)
{
   printf( " h/?   - this help.\n" );
   printf( " a     - toggle animation. (%s)\n", animate_on ? "On" : "Off" );
   printf( " +/-   - increase/decrease animation speed\n" );
   printf( " s     - stop animation.\n" );
   printf( " r     - increase rotAngle %0.2f\n", rotAngle );
   printf( " 2/3/4 - set line width 3, 6, 12 resp.\n" );
   printf( " R     - reset.\n" );
   printf( " ESC/q - quit.\n" );
}

static int ms_wait63 = 55;

static void
animate63(void)
{
   if( ms_wait63 && check_timeout( ms_wait63 ) )
      return;

   rotAngle += 1.0;
   if (rotAngle >= 360.0) rotAngle = 0.0;
   display63();
}


void keyboard63(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'a':
         animate_on = !animate_on;
         if(animate_on)
            glutIdleFunc(animate63);
         else
            glutIdleFunc(NULL);
         printf( "a - toggle animation. (%s)\n", animate_on ? "On" : "Off" );
         break;
      case 's':
         glutIdleFunc(NULL);
         animate_on = false;
         printf( "s - stop animation.\n" );
         break;
      case 'r':
         rotAngle += 20.;
         if (rotAngle >= 360.) rotAngle = 0.;
         printf( "r - increase rotAngle %0.1f\n", rotAngle );
         glutPostRedisplay();   
         break;
      case 'h':
      case '?':
         key_help63();
         break;
      case 'R':
         rotAngle = 0.0;
         glLineWidth (1.5);
         glutIdleFunc(NULL);
         glutPostRedisplay();
         break;
      case '2':
         glLineWidth (3.0);
         glutPostRedisplay();
         break;
      case '3':
         glLineWidth (6.0);
         glutPostRedisplay();
         break;
      case '4':
         glLineWidth (12.0);
         glutPostRedisplay();
         break;
      case '+':
         if(ms_wait63)
            ms_wait63--;
         break;
      case '-':
         ms_wait63++;
         break;
    }
}

//   case 14:
//      return main63(argc, argv); // antialiasing - trying to smooth out lines
int main63(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (200, 200);
   glutCreateWindow (argv[0]);
   init63();
   glutReshapeFunc (reshape63);
   glutKeyboardFunc (keyboard63);
   glutDisplayFunc (display63);
   key_help63();
   glutMainLoop();
   return 0;
}


// **************************************************************
// Example 6-4 : Antialiasing in Color-Index Mode: aaindex.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>

#define RAMPSIZE 16
#define RAMP1START 32
#define RAMP2START 48

//static float rotAngle = 0.;

/*  Initialize antialiasing for color-index mode,
 *  including loading a green color ramp starting
 *  at RAMP1START, and a blue color ramp starting
 *  at RAMP2START. The ramps must be a multiple of 16.
 */
void init64(void)
{
   int i;
   for (i = 0; i < RAMPSIZE; i++) {
      GLfloat shade;
      shade = (GLfloat) i/(GLfloat) RAMPSIZE;
      glutSetColor(RAMP1START+(GLint)i, 0.0, shade, 0.0);
      glutSetColor(RAMP2START+(GLint)i, 0.0, 0.0, shade);
   }

   glEnable (GL_LINE_SMOOTH);
   glHint (GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
   glLineWidth (1.5);

   glClearIndex ((GLfloat) RAMP1START);
}
/*  Draw 2 diagonal lines to form an X */
void display64(void)
{
   glClear(GL_COLOR_BUFFER_BIT);

   glIndexi(RAMP1START);
   glPushMatrix();
   glRotatef(-rotAngle, 0.0, 0.0, 0.1);  // angle,x,y,z
   glBegin (GL_LINES);
      glVertex2f (-0.5, 0.5);
      glVertex2f (0.5, -0.5);
   glEnd ();
   glPopMatrix();

   glIndexi(RAMP2START);
   glPushMatrix();
   glRotatef(rotAngle, 0.0, 0.0, 0.1);  // angle,x,y,z
   glBegin (GL_LINES);
      glVertex2f (0.5, 0.5);
      glVertex2f (-0.5, -0.5);
   glEnd ();
   glPopMatrix();

   glFlush();
}


void reshape64(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h) 
      gluOrtho2D (-1.0, 1.0, 
         -1.0*(GLfloat)h/(GLfloat)w, 1.0*(GLfloat)h/(GLfloat)w);
   else 
      gluOrtho2D (-1.0*(GLfloat)w/(GLfloat)h, 
         1.0*(GLfloat)w/(GLfloat)h, -1.0, 1.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}
void keyboard64(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'r':
      case 'R':
         rotAngle += 20.;
         if (rotAngle >= 360.) rotAngle = 0.;
         glutPostRedisplay();   
         break;
      case 27:  /*  Escape Key */
         pgm_exit(0);
         break;
      default:
         break;
    }
}

//   case 15:
//      return main64(argc, argv); // antialiasing - trying to smooth out lines
//      // but NO DISPLAY???
int main64(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_INDEX);
   glutInitWindowSize (200, 200);
   glutCreateWindow (argv[0]);
   init64();
   glutReshapeFunc (reshape64);
   glutKeyboardFunc (keyboard64);
   glutDisplayFunc (display64);
   glutMainLoop();
   return 0;
}

// **********************************************************************
// Example 6-5 : Antialiasing Filled Polygons: aapoly.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <stdio.h>
#include <string.h>

static GLboolean polySmooth = GL_TRUE;
static void init65(void)
{
   glCullFace (GL_BACK);
   glEnable (GL_CULL_FACE);
   glBlendFunc (GL_SRC_ALPHA_SATURATE, GL_ONE);
   glClearColor (0.0, 0.0, 0.0, 0.0);
}

#define NFACE 6
#define NVERT 8
void drawCube65(GLdouble x0, GLdouble x1, GLdouble y0, 
              GLdouble y1, GLdouble z0, GLdouble z1)
{
   static GLfloat v[8][3];
   static GLfloat c[8][4] = {
      {0.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 1.0},
      {0.0, 1.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 1.0},
      {0.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 1.0},
      {0.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}
   };

/*  indices of front, top, left, bottom, right, back faces  */
   static GLubyte indices[NFACE][4] = {
      {4, 5, 6, 7}, {2, 3, 7, 6}, {0, 4, 7, 3},
      {0, 1, 5, 4}, {1, 5, 6, 2}, {0, 3, 2, 1}
   };

   v[0][0] = v[3][0] = v[4][0] = v[7][0] = x0;
   v[1][0] = v[2][0] = v[5][0] = v[6][0] = x1;
   v[0][1] = v[1][1] = v[4][1] = v[5][1] = y0;
   v[2][1] = v[3][1] = v[6][1] = v[7][1] = y1;
   v[0][2] = v[1][2] = v[2][2] = v[3][2] = z0;
   v[4][2] = v[5][2] = v[6][2] = v[7][2] = z1;

   // GL_VERSION_1_1
#ifdef GL_VERSION_1_1
   glEnableClientState (GL_VERTEX_ARRAY);
   glEnableClientState (GL_COLOR_ARRAY);
   glVertexPointer (3, GL_FLOAT, 0, v);
   glColorPointer (4, GL_FLOAT, 0, c);
   glDrawElements(GL_QUADS, NFACE*4, GL_UNSIGNED_BYTE, indices);
   glDisableClientState (GL_VERTEX_ARRAY);
   glDisableClientState (GL_COLOR_ARRAY);
#else
   printf ("If this is GL Version 1.0, ");
   printf ("vertex arrays are not supported.\n");
   pgm_exit(1);
#endif
}
/*  Note:  polygons must be drawn from front to back
 *  for proper blending.
 */
void display65(void)
{
   if (polySmooth) {
      glClear (GL_COLOR_BUFFER_BIT);
      glEnable (GL_BLEND);
      glEnable (GL_POLYGON_SMOOTH);
      glDisable (GL_DEPTH_TEST);
   }
   else { 
      glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
      glDisable (GL_BLEND);
      glDisable (GL_POLYGON_SMOOTH);
      glEnable (GL_DEPTH_TEST);
   }

   glPushMatrix ();
      glTranslatef (0.0, 0.0, -8.0);    
      glRotatef (30.0, 1.0, 0.0, 0.0);  // angle,x,y,z
      glRotatef (60.0, 0.0, 1.0, 0.0);   // angle,x,y,z
      drawCube65(-0.5, 0.5, -0.5, 0.5, -0.5, 0.5);
   glPopMatrix ();

   glFlush ();
}

void reshape65(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(30.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}
void keyboard65(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 't':
      case 'T':
         polySmooth = !polySmooth;
         printf("polySmooth is %s\n", (polySmooth ? "On" : "Off"));
         glutPostRedisplay();
         break;
      case 27:
         pgm_exit(0);  /*  Escape key  */
         break;
      default:
         break;
   }
}

//   case 16:
//      printf(" 16: main65(argc, argv); // colorful little cube - on/off smoothing\n" );
// but shows no difference in WIN32
int main65(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB 
                        | GLUT_ALPHA | GLUT_DEPTH);
   glutInitWindowSize(200, 200);
   glutCreateWindow(argv[0]);
   init65 ();
   glutReshapeFunc (reshape65);
   glutKeyboardFunc (keyboard65);
   glutDisplayFunc (display65);
   glutMainLoop();
   return 0;
}

// *****************************************************
// Example 6-6 : Five Fogged Spheres in RGBA Mode: fog.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <math.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <stdio.h>

static GLint fogMode;

static void init66(void)
{
   GLfloat position[] = { 0.5, 0.5, 3.0, 0.0 };

   glEnable(GL_DEPTH_TEST);

   glLightfv(GL_LIGHT0, GL_POSITION, position);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   {
      GLfloat mat[3] = {0.1745, 0.01175, 0.01175};      
      glMaterialfv (GL_FRONT, GL_AMBIENT, mat);
      mat[0] = 0.61424; mat[1] = 0.04136; mat[2] = 0.04136;     
      glMaterialfv (GL_FRONT, GL_DIFFUSE, mat);
      mat[0] = 0.727811; mat[1] = 0.626959; mat[2] = 0.626959;
      glMaterialfv (GL_FRONT, GL_SPECULAR, mat);
      glMaterialf (GL_FRONT, GL_SHININESS, 0.6*128.0);
   }

   glEnable(GL_FOG);
   {
      GLfloat fogColor[4] = {0.5, 0.5, 0.5, 1.0};

      fogMode = GL_EXP;
      glFogi (GL_FOG_MODE, fogMode);
      glFogfv (GL_FOG_COLOR, fogColor);
      glFogf (GL_FOG_DENSITY, 0.35);
      glHint (GL_FOG_HINT, GL_DONT_CARE);
      glFogf (GL_FOG_START, 1.0);
      glFogf (GL_FOG_END, 5.0);
   }
   glClearColor(0.5, 0.5, 0.5, 1.0);  /* fog color */
}

static void renderSphere66 (GLfloat x, GLfloat y, GLfloat z)
{
   glPushMatrix();
   glTranslatef (x, y, z);
   glutSolidSphere(0.4, 16, 16);
   glPopMatrix();
}

/* display() draws 5 spheres at different z positions.
 */
void display66(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   renderSphere66 (-2., -0.5, -1.0);
   renderSphere66 (-1., -0.5, -2.0);
   renderSphere66 (0., -0.5, -3.0);
   renderSphere66 (1., -0.5, -4.0);
   renderSphere66 (2., -0.5, -5.0);
   glFlush();
}

void reshape66(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-2.5, 2.5, -2.5*(GLfloat)h/(GLfloat)w,
         2.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
   else
      glOrtho (-2.5*(GLfloat)w/(GLfloat)h,
         2.5*(GLfloat)w/(GLfloat)h, -2.5, 2.5, -10.0, 10.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity ();
}

void keyboard66(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'f':
      case 'F':
         if (fogMode == GL_EXP) {
            fogMode = GL_EXP2;
            printf ("Fog mode is GL_EXP2\n");
         }
         else if (fogMode == GL_EXP2) {
            fogMode = GL_LINEAR;
            printf ("Fog mode is GL_LINEAR\n");
         }
         else if (fogMode == GL_LINEAR) {
            fogMode = GL_EXP;
            printf ("Fog mode is GL_EXP\n");
         }
         glFogi (GL_FOG_MODE, fogMode);
         glutPostRedisplay();
         break;
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
}

int main66(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500, 500);
   glutCreateWindow(argv[0]);
   init66();
   glutReshapeFunc (reshape66);
   glutKeyboardFunc (keyboard66);
   glutDisplayFunc (display66);
   glutMainLoop();
   return 0;
}


// eof - ogl06.cxx
