// ogl07.cxx

#include "ogl02.hxx"

//Example 7-1 : Creating a Display List: torus.c
//#include <GL/gl.h>
//#include <GL/glu.h>
#include <stdio.h>
#include <math.h>
//#include <GL/glut.h>
#include <stdlib.h>

static GLuint theTorus;

/* Draw a torus */
static void torus71(int numc, int numt)
{
   int i, j, k;
   double s, t, x, y, z, twopi;

   twopi = 2 * (double)M_PI;
   for (i = 0; i < numc; i++) {
      glBegin(GL_QUAD_STRIP);
      for (j = 0; j <= numt; j++) {
         for (k = 1; k >= 0; k--) {
            s = (i + k) % numc + 0.5;
            t = j % numt;

            x = (1+.1*cos(s*twopi/numc))*cos(t*twopi/numt);
            y = (1+.1*cos(s*twopi/numc))*sin(t*twopi/numt);
            z = .1 * sin(s * twopi / numc);
            glVertex3f(x, y, z);
         }
      }
      glEnd();
   }
}

/* Create display list with Torus and initialize state*/
static void init71(void)
{
   theTorus = glGenLists (1);
   glNewList(theTorus, GL_COMPILE);
   torus71(8, 25);
   glEndList();

   glShadeModel(GL_FLAT);
   glClearColor(0.0, 0.0, 0.0, 0.0);
}

void display71(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glCallList(theTorus);
   glFlush();
}

void reshape71(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(30, (GLfloat) w/(GLfloat) h, 1.0, 100.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt(0, 0, 10, 0, 0, 0, 0, 1, 0);
}

/* Rotate about x-axis when "x" typed; rotate about y-axis
   when "y" typed; "i" returns torus to original view */
void keyboard71(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
   case 'x':
   case 'X':
      glRotatef(30.0,1.0,0.0,0.0);  // angle,x,y,z
      glutPostRedisplay();
      break;
   case 'y':
   case 'Y':
      glRotatef(30.0,0.0,1.0,0.0);  // angle,x,y,z
      glutPostRedisplay();
      break;
   case 'i':
   case 'I':
      glLoadIdentity();
      gluLookAt(0, 0, 10, 0, 0, 0, 0, 1, 0);
      glutPostRedisplay();
      break;
   case 27:
      pgm_exit(0);
      break;
   }
}

int main71(int argc, char **argv)
{
   glutInitWindowSize(200, 200);
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
   glutCreateWindow(argv[0]);
   init71();
   glutReshapeFunc(reshape71);
   glutKeyboardFunc(keyboard71);
   glutDisplayFunc(display71);
   glutMainLoop();
   return 0;
}

// **********************************************************
//Example 7-2 : Using a Display List: list.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>

static GLuint listName;

static void init72 (void)
{
   listName = glGenLists (1);
   // Note: Zero is not a valid display-list index.
   if(!listName) {
      printf("ERROR: glGenLists(1) FAILED!\n");
      pgm_exit(1);
   }
   glNewList (listName, GL_COMPILE);
      glColor3f (1.0, 0.0, 0.0);  /*  current color red  */
      glBegin (GL_TRIANGLES);
      glVertex2f (0.0, 0.0);
      glVertex2f (1.0, 0.0);
      glVertex2f (0.0, 1.0);
      glEnd ();
      glTranslatef (1.5, 0.0, 0.0); /*  move position  */
   glEndList ();
   glShadeModel (GL_FLAT);
}

static void drawLine72 (void)
{
   glBegin (GL_LINES);
   glVertex2f (0.0, 0.5);
   glVertex2f (15.0, 0.5);
   glEnd ();
}

void display72(void)
{
   GLuint i;

   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (0.0, 1.0, 0.0);  /*  current color green - will have NO effect */
   for (i = 0; i < 10; i++)    /*  draw 10 triangles    */
      glCallList (listName);  // list was set with RED color

   // so NEED to put back the color to green, for the line, at right
   glColor3f (0.0, 1.0, 0.0);  /*  current color green  */
   drawLine72 ();  /*  is this line green?  NO, unless glColor set!  */
   /*  where is the line drawn?  - to the far right, after triangles */

   glFlush ();
}

void reshape72(int w, int h)
{
   glViewport(0, 0, w, h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h) 
      gluOrtho2D (0.0, 2.0, -0.5 * (GLfloat) h/(GLfloat) w, 
         1.5 * (GLfloat) h/(GLfloat) w);
   else 
      gluOrtho2D (0.0, 2.0*(GLfloat) w/(GLfloat) h, -0.5, 1.5); 
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void keyboard72(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 27:
         pgm_exit(0);
   }
}

int main72(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   //glutInitWindowSize(650, 50);
   glutInitWindowSize(1000, 50);
   glutCreateWindow(argv[0]);
   init72 ();
   glutReshapeFunc (reshape72);
   glutKeyboardFunc (keyboard72);
   glutDisplayFunc (display72);
   glutMainLoop();
   return 0;
}

// ===================================================================
// Example 7-5 : Multiple Display Lists to Define a Stroked Font: stroke.c
// MOVED TO ogl-fonts.cxx


// eof - ogl07.cxx
