// ogl08.cxx
#include "ogl02.hxx"
//Example 8-2 : Drawing a Complete Font: font.c
// MOVED TO ogl-fonts.cxx


// ============================================================
// Example 8-4 : Drawing, Copying, and Zooming Pixel Data: image.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
#include <stdio.h>   // for printf()

#define checkImageWidth 64
#define checkImageHeight 64
static GLubyte checkImage[checkImageHeight][checkImageWidth][3];

static GLdouble zoomFactor = 1.0;
static GLint height;
static bool check_bounds = false;

void makeCheckImage(void)
{
   int i, j, c;
   for (i = 0; i < checkImageHeight; i++) {
      for (j = 0; j < checkImageWidth; j++) {
         c = (((((i & 0x8) == 0 )^(( j & 0x8 )) == 0 )))*255;
         checkImage[i][j][0] = (GLubyte) c;
         checkImage[i][j][1] = (GLubyte) c;
         checkImage[i][j][2] = (GLubyte) c;
      }
   }
}

void init84(void)
{    
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
   makeCheckImage();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
}

void display84(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glRasterPos2i(0, 0);
   glDrawPixels(checkImageWidth, checkImageHeight, GL_RGB, 
                GL_UNSIGNED_BYTE, checkImage);
   glFlush();
}

void reshape84(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   height = (GLint) h;
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluOrtho2D(0.0, (GLdouble) w, 0.0, (GLdouble) h);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void motion84(int x, int y)
{
   static GLint screeny;
   
   screeny = height - (GLint) y;
   glRasterPos2i (x, screeny);
   glPixelZoom (zoomFactor, zoomFactor);
   glCopyPixels (0, 0, checkImageWidth, checkImageHeight,
                 GL_COLOR);
   glPixelZoom (1.0, 1.0);
   glFlush ();
}

void keyboard84(unsigned char key, int x, int y)
{
   int done = 0;
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'r':
      case 'R':
         zoomFactor = 1.0;
         printf ("zoomFactor reset to 1.0\n");
         done = 1;
         break;
      case 'z':
         zoomFactor += 0.5;
         if (check_bounds && (zoomFactor > 3.0) )
            zoomFactor = 3.0;
         printf ("zoomFactor is now %4.1f\n", zoomFactor);
         done = 1;
         break;
      case 'Z':
         zoomFactor -= 0.5;
         if (zoomFactor < 0.5)
            zoomFactor = 0.5;
         printf ("zoomFactor is now %4.1f\n", zoomFactor);
         done = 1;
         break;
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
   if(done)
      glutPostRedisplay();
}

int main84(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize(250, 250);
   glutInitWindowPosition(100, 100);
   glutCreateWindow(argv[0]);
   init84();
   glutDisplayFunc(display84);
   glutReshapeFunc(reshape84);
   glutKeyboardFunc(keyboard84);
   glutMotionFunc(motion84);
   glutMainLoop();
   return 0; 
}


// eof - ogl08.cxx
