// ogl09.cxx

#include "ogl02.hxx"

//Example 9-1 : Texture-Mapped Checkerboard: checker.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
#include <stdio.h>   // for printf()

/*  Create checkerboard texture  */
#define checkImageWidth 64
#define checkImageHeight 64
static GLubyte checkImage[checkImageHeight][checkImageWidth][4];

static GLuint texName;

static void makeCheckImage91(void)
{
   int i, j, c;
    
   for (i = 0; i < checkImageHeight; i++) {
      for (j = 0; j < checkImageWidth; j++) {
         c = ((((i&0x8)==0)^((j&0x8))==0))*255;
         checkImage[i][j][0] = (GLubyte) c;
         checkImage[i][j][1] = (GLubyte) c;
         checkImage[i][j][2] = (GLubyte) c;
         checkImage[i][j][3] = (GLubyte) 255;
      }
   }
}

void init91(void)
{    
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
   glEnable(GL_DEPTH_TEST);

   makeCheckImage91();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(1, &texName);
   glBindTexture(GL_TEXTURE_2D, texName);

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
                   GL_NEAREST);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, checkImageWidth, 
                checkImageHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, 
                checkImage);
}

void display91(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glEnable(GL_TEXTURE_2D);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   glBindTexture(GL_TEXTURE_2D, texName);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(-2.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(-2.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(0.0, 1.0, 0.0);
   glTexCoord2f(1.0, 0.0); glVertex3f(0.0, -1.0, 0.0);

   glTexCoord2f(0.0, 0.0); glVertex3f(1.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(1.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(2.41421, 1.0, -1.41421);
   glTexCoord2f(1.0, 0.0); glVertex3f(2.41421, -1.0, -1.41421);
   glEnd();
   glFlush();
   glDisable(GL_TEXTURE_2D);
}

void reshape91(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 30.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef(0.0, 0.0, -3.6);
}

void keyboard91 (unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
}

int main91(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(250, 250);
   glutInitWindowPosition(100, 100);
   glutCreateWindow(argv[0]);
   init91();
   glutDisplayFunc(display91);
   glutReshapeFunc(reshape91);
   glutKeyboardFunc(keyboard91);
   glutMainLoop();
   return 0; 
}

// =======================================================
// Example 9-3 : Replacing a Texture Subimage: texsub.c

/*  Create checkerboard textures  */
#define checkImageWidth93 64
#define checkImageHeight93 64
#define subImageWidth93 16
#define subImageHeight93 16
static GLubyte checkImage93[checkImageHeight93][checkImageWidth93][4];
static GLubyte subImage93[subImageHeight93][subImageWidth93][4];

void makeCheckImages93(void)
{
   int i, j, c;

   for (i = 0; i < checkImageHeight93; i++) {
      for (j = 0; j < checkImageWidth93; j++) {
         c = ((((i&0x8)==0)^((j&0x8))==0))*255;
         checkImage93[i][j][0] = (GLubyte) c;
         checkImage93[i][j][1] = (GLubyte) c;
         checkImage93[i][j][2] = (GLubyte) c;
         checkImage93[i][j][3] = (GLubyte) 255;
      }
   }
   for (i = 0; i < subImageHeight93; i++) {
      for (j = 0; j < subImageWidth93; j++) {
         c = ((((i&0x4)==0)^((j&0x4))==0))*255;
         subImage93[i][j][0] = (GLubyte) c;
         subImage93[i][j][1] = (GLubyte) 0;
         subImage93[i][j][2] = (GLubyte) 0;
         subImage93[i][j][3] = (GLubyte) 255;
      }
   }
}

void keyboard93 (unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 's':
      case 'S':
         glBindTexture(GL_TEXTURE_2D, texName);
         glTexSubImage2D(GL_TEXTURE_2D, 0, 12, 44, 
                         subImageWidth93, subImageHeight93, GL_RGBA,
                         GL_UNSIGNED_BYTE, subImage93);
         glutPostRedisplay();
         break;
      case 'r':
      case 'R':
         glBindTexture(GL_TEXTURE_2D, texName);
         glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 
                      checkImageWidth93, checkImageHeight93, 0,
                      GL_RGBA, GL_UNSIGNED_BYTE, checkImage93);
         glutPostRedisplay();
         break;
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
}

void init93(void)
{    
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
   glEnable(GL_DEPTH_TEST);

   makeCheckImages93();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(1, &texName);
   glBindTexture(GL_TEXTURE_2D, texName);

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
                   GL_NEAREST);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, checkImageWidth93, 
                checkImageHeight93, 0, GL_RGBA, GL_UNSIGNED_BYTE, 
                checkImage93);
}

void display93(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glEnable(GL_TEXTURE_2D);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   glBindTexture(GL_TEXTURE_2D, texName);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(-2.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(-2.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(0.0, 1.0, 0.0);
   glTexCoord2f(1.0, 0.0); glVertex3f(0.0, -1.0, 0.0);

   glTexCoord2f(0.0, 0.0); glVertex3f(1.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(1.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(2.41421, 1.0, -1.41421);
   glTexCoord2f(1.0, 0.0); glVertex3f(2.41421, -1.0, -1.41421);
   glEnd();
   glFlush();
   glDisable(GL_TEXTURE_2D);
}

void reshape93(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 30.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef(0.0, 0.0, -3.6);
}

int main93(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(250, 250);
   glutInitWindowPosition(100, 100);
   glutCreateWindow(argv[0]);
   init93();
   glutDisplayFunc(display93);
   glutReshapeFunc(reshape93);
   glutKeyboardFunc(keyboard93);
   glutMainLoop();
   return 0; 
}


// *******************************************************
//Example 9-4 : Mipmap Textures: mipmap.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>

static GLubyte mipmapImage32[32][32][4];
static GLubyte mipmapImage16[16][16][4];
static GLubyte mipmapImage8[8][8][4];
static GLubyte mipmapImage4[4][4][4];
static GLubyte mipmapImage2[2][2][4];
static GLubyte mipmapImage1[1][1][4];

static GLuint texName94;

void makeImages94(void)
{
   int i, j;
    
   for (i = 0; i < 32; i++) {
      for (j = 0; j < 32; j++) {
         mipmapImage32[i][j][0] = 255;
         mipmapImage32[i][j][1] = 255;
         mipmapImage32[i][j][2] = 0;
         mipmapImage32[i][j][3] = 255;
      }
   }
   for (i = 0; i < 16; i++) {
      for (j = 0; j < 16; j++) {
         mipmapImage16[i][j][0] = 255;
         mipmapImage16[i][j][1] = 0;
         mipmapImage16[i][j][2] = 255;
         mipmapImage16[i][j][3] = 255;
      }
   }
   for (i = 0; i < 8; i++) {
      for (j = 0; j < 8; j++) {
         mipmapImage8[i][j][0] = 255;
         mipmapImage8[i][j][1] = 0;
         mipmapImage8[i][j][2] = 0;
         mipmapImage8[i][j][3] = 255;
      }
   }
   for (i = 0; i < 4; i++) {
      for (j = 0; j < 4; j++) {
         mipmapImage4[i][j][0] = 0;
         mipmapImage4[i][j][1] = 255;
         mipmapImage4[i][j][2] = 0;
         mipmapImage4[i][j][3] = 255;
      }
   }
   for (i = 0; i < 2; i++) {
      for (j = 0; j < 2; j++) {
         mipmapImage2[i][j][0] = 0;
         mipmapImage2[i][j][1] = 0;
         mipmapImage2[i][j][2] = 255;
         mipmapImage2[i][j][3] = 255;
      }
   }
   mipmapImage1[0][0][0] = 255;
   mipmapImage1[0][0][1] = 255;
   mipmapImage1[0][0][2] = 255;
   mipmapImage1[0][0][3] = 255;
}

void init94(void)
{    
   glEnable(GL_DEPTH_TEST);
   glShadeModel(GL_FLAT);

   glTranslatef(0.0, 0.0, -3.6);
   makeImages94();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(1, &texName94);
   glBindTexture(GL_TEXTURE_2D, texName94);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
                   GL_NEAREST_MIPMAP_NEAREST);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 32, 32, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage32);
   glTexImage2D(GL_TEXTURE_2D, 1, GL_RGBA, 16, 16, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage16);
   glTexImage2D(GL_TEXTURE_2D, 2, GL_RGBA, 8, 8, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage8);
   glTexImage2D(GL_TEXTURE_2D, 3, GL_RGBA, 4, 4, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage4);
   glTexImage2D(GL_TEXTURE_2D, 4, GL_RGBA, 2, 2, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage2);
   glTexImage2D(GL_TEXTURE_2D, 5, GL_RGBA, 1, 1, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, mipmapImage1);

   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   glEnable(GL_TEXTURE_2D);
}

void display94(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glBindTexture(GL_TEXTURE_2D, texName94);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(-2.0, -1.0, 0.0);
   glTexCoord2f(0.0, 8.0); glVertex3f(-2.0, 1.0, 0.0);
   glTexCoord2f(8.0, 8.0); glVertex3f(2000.0, 1.0, -6000.0);
   glTexCoord2f(8.0, 0.0); glVertex3f(2000.0, -1.0, -6000.0);
   glEnd();
   glFlush();
}

void reshape94(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60.0, (GLfloat)w/(GLfloat)h, 1.0, 30000.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void keyboard94 (unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
}

int main94(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500, 500);
   glutInitWindowPosition(50, 50);
   glutCreateWindow(argv[0]);
   init94();
   glutDisplayFunc(display94);
   glutReshapeFunc(reshape94);
   glutKeyboardFunc(keyboard94);
   glutMainLoop();
   return 0;
}

// **********************************************************
//Example 9-5 : Binding Texture Objects: texbind.c

#define checkImageWidth95 64
#define checkImageHeight95 64
static GLubyte checkImage95[checkImageHeight95][checkImageWidth95][4];
static GLubyte otherImage95[checkImageHeight95][checkImageWidth95][4];

static GLuint texName95[2];

void makeCheckImages95(void)
{
   int i, j, c;
    
   for (i = 0; i < checkImageHeight95; i++) {
      for (j = 0; j < checkImageWidth95; j++) {
         c = ((((i&0x8)==0)^((j&0x8))==0))*255;
         checkImage95[i][j][0] = (GLubyte) c;
         checkImage95[i][j][1] = (GLubyte) c;
         checkImage95[i][j][2] = (GLubyte) c;
         checkImage95[i][j][3] = (GLubyte) 255;
         c = ((((i&0x10)==0)^((j&0x10))==0))*255;
         otherImage95[i][j][0] = (GLubyte) c;
         otherImage95[i][j][1] = (GLubyte) 0;
         otherImage95[i][j][2] = (GLubyte) 0;
         otherImage95[i][j][3] = (GLubyte) 255;
      }
   }
}

void init95(void)
{    
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
   glEnable(GL_DEPTH_TEST);

   makeCheckImages95();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(2, &texName95[0]);

   glBindTexture(GL_TEXTURE_2D, texName95[0]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
                   GL_NEAREST);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, checkImageWidth95,
                checkImageHeight95, 0, GL_RGBA, GL_UNSIGNED_BYTE,
                checkImage95);

   glBindTexture(GL_TEXTURE_2D, texName95[1]);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
                   GL_NEAREST);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);   
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, checkImageWidth95, 
                checkImageHeight95, 0, GL_RGBA, GL_UNSIGNED_BYTE, 
                otherImage95);
   glEnable(GL_TEXTURE_2D);
}

void display95(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glBindTexture(GL_TEXTURE_2D, texName95[0]);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(-2.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(-2.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(0.0, 1.0, 0.0);
   glTexCoord2f(1.0, 0.0); glVertex3f(0.0, -1.0, 0.0);
   glEnd();

   glBindTexture(GL_TEXTURE_2D, texName95[1]);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(1.0, -1.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(1.0, 1.0, 0.0);
   glTexCoord2f(1.0, 1.0); glVertex3f(2.41421, 1.0, -1.41421);
   glTexCoord2f(1.0, 0.0); glVertex3f(2.41421, -1.0, -1.41421);
   glEnd();
   glFlush();
}

void keyboard95 (unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 27:
         pgm_exit(0);
         break;
      default:
         break;
   }
}

void reshape95(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60.0, (GLfloat)w/(GLfloat)h, 1.0, 30000.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

int main95(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500, 500);
   glutInitWindowPosition(50, 50);
   glutCreateWindow(argv[0]);
   init95();
   glutDisplayFunc(display95);
   glutReshapeFunc(reshape95);
   glutKeyboardFunc(keyboard95);
   glutMainLoop();
   return 0;
}

// **********************************************************************
//Example 9-6 : Automatic Texture-Coordinate Generation: texgen.c
//#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glut.h>
//#include <stdlib.h>
//#include <stdio.h>

#define stripeImageWidth96 32
GLubyte stripeImage96[4*stripeImageWidth96];

static bool use_double_buf96 = true;
static bool do_animate_96 = true;

static GLuint texName96;
static GLfloat angle96 = 45.0;
static GLfloat angleAdd = 0.1;

void makeStripeImage96(void)
{
   int j;
    
   for (j = 0; j < stripeImageWidth96; j++) {
      stripeImage96[4*j] = (GLubyte) ((j<=4) ? 255 : 0);
      stripeImage96[4*j+1] = (GLubyte) ((j>4) ? 255 : 0);
      stripeImage96[4*j+2] = (GLubyte) 0;
      stripeImage96[4*j+3] = (GLubyte) 255;
   }
}

/*  planes for texture coordinate generation  */
static GLfloat xequalzero[] = {1.0, 0.0, 0.0, 0.0};
static GLfloat slanted[] = {1.0, 1.0, 1.0, 0.0};
static GLfloat *currentCoeff;
static GLenum currentPlane;
static GLint currentGenMode;

void init96(void)
{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glEnable(GL_DEPTH_TEST);
   glShadeModel(GL_SMOOTH);

   makeStripeImage96();
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(1, &texName96);
   glBindTexture(GL_TEXTURE_1D, texName96);
   glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER,
                   GL_LINEAR);
   glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER,
                   GL_LINEAR);
   glTexImage1D(GL_TEXTURE_1D, 0, GL_RGBA, stripeImageWidth96, 0,
                GL_RGBA, GL_UNSIGNED_BYTE, stripeImage96);

   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
   currentCoeff = xequalzero;
   currentGenMode = GL_OBJECT_LINEAR;
   currentPlane = GL_OBJECT_PLANE;
   glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, currentGenMode);
   glTexGenfv(GL_S, currentPlane, currentCoeff);

   glEnable(GL_TEXTURE_GEN_S);
   glEnable(GL_TEXTURE_1D);
   glEnable(GL_CULL_FACE);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_AUTO_NORMAL);
   glEnable(GL_NORMALIZE);
   glFrontFace(GL_CW);
   glCullFace(GL_BACK);
   glMaterialf (GL_FRONT, GL_SHININESS, 64.0);
}

static void
display96(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   glPushMatrix ();

      glRotatef(angle96, 0.0, 0.0, 1.0);  // angle,x,y,z
      glBindTexture(GL_TEXTURE_1D, texName96);
      glutSolidTeapot(2.0);

   glPopMatrix ();

   if(use_double_buf96)
      glutSwapBuffers();
   else
      glFlush();
}

static void
idle96(void)
{
   if( do_animate_96 ) {
      angle96 += angleAdd;
      if(angle96 > 360.0)
         angle96 = 0.0;
      glutPostRedisplay();
   }
}

static void
reshape96(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-3.5, 3.5, -3.5*(GLfloat)h/(GLfloat)w, 
               3.5*(GLfloat)h/(GLfloat)w, -3.5, 3.5);
   else
      glOrtho (-3.5*(GLfloat)w/(GLfloat)h, 
               3.5*(GLfloat)w/(GLfloat)h, -3.5, 3.5, -3.5, 3.5);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

static void key_help96(void)
{
   printf( " h/?    - this help.\n" );
   printf( " e/E    - Set Eye Linear.\n" );
   printf( " o/O    - Set Object Linear.\n" );
   printf( " s/S    - Set Coef slanted.\n" );
   printf( " x/X    - Set Coef zero.\n" );
   printf( " r/R    - Reset defaults.\n" );
   printf( " a/A    - Toggle animation. (now %s)\n", do_animate_96 ? "On" : "Off" );
   printf( " +/-    - increase/decrease angle change per interations. (now %f)\n", angleAdd );
   printf( " ESC/q  - exit.\n" );
}

void keyboard96 (unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch (key) {
      case 'h':
      case '?':
         key_help96();
         break;
      case 'e':
      case 'E':
         currentGenMode = GL_EYE_LINEAR;
         currentPlane = GL_EYE_PLANE;
         glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, currentGenMode);
         glTexGenfv(GL_S, currentPlane, currentCoeff);
         printf( "%c - Set Eye Linear.\n", key );
         glutPostRedisplay();
         break;
      case 'o':
      case 'O':
         currentGenMode = GL_OBJECT_LINEAR;
         currentPlane = GL_OBJECT_PLANE;
         glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, currentGenMode);
         glTexGenfv(GL_S, currentPlane, currentCoeff);
         printf( "%c - Set Object Linear.\n", key );
         glutPostRedisplay();
         break;
      case 's':
      case 'S':
         currentCoeff = slanted;
         glTexGenfv(GL_S, currentPlane, currentCoeff);
         printf( "%c - Set Coef slanted.\n", key );
         glutPostRedisplay();
         break;
      case 'x':
      case 'X':
         currentCoeff = xequalzero;
         glTexGenfv(GL_S, currentPlane, currentCoeff);
         printf( "%c - Set Coef zero.\n", key );
         glutPostRedisplay();
         break;
      case 'r':
      case 'R':
         currentCoeff = xequalzero;
         currentGenMode = GL_OBJECT_LINEAR;
         currentPlane = GL_OBJECT_PLANE;
         glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, currentGenMode);
         glTexGenfv(GL_S, currentPlane, currentCoeff);
         angleAdd = 0.1;
         printf( "%c - Reset defaults.\n", key );
         glutPostRedisplay();
         break;
      case 'a':
      case 'A':
         do_animate_96 = !do_animate_96;
         printf( "%c - Toggle animation. (now %s)\n", key, 
            (do_animate_96 ? "On" : "Off") );
         break;
      case '+':
         angleAdd *= 2.0;
         printf("+ increased angle change to %f degrees\n", angleAdd);
         break;
      case '-':
         angleAdd /= 2.0;
         printf("- decreased angle change to %f degrees\n", angleAdd);
         break;
   }
}

//   case ex_27:
//     printf(": main96(argc,argv);  // adding stripes - e o s x - to teapot" );
int main96(int argc, char** argv)
{
   glutInit(&argc, argv);
   if(use_double_buf96)
      glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   else
      glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(256, 256);
   glutInitWindowPosition(100, 100);
   glutCreateWindow (argv[0]);
   init96 ();
   glutDisplayFunc(display96);
   glutReshapeFunc(reshape96);
   glutKeyboardFunc(keyboard96);
   glutIdleFunc(idle96);
   key_help96();
   // printf("Keyboard: e o s x ESC\n" );
   glutMainLoop();
   return 0;
}

// eof - ogl09.cxx
