// ogl12.cxx - taken from test_glut16.cxx
// from : 16/05/2009  18:00         2,939,399 glut_examples.zip
// surfgrid.c - downloaded from
// http://www.opengl.org/resources/code/samples/glut_examples/examples/examples.html

/**
 * surfgrid.c - simple test of polygon offset
 *
 * GLUT distribution version  $Revision: 1.7 $
 *
 * usage:
 *	surfgrid [-f]
 *
 * options:
 *	-f	run on full screen
 *
 * keys:
 *	p	toggle polygon offset
 *      F       increase polygon offset factor
 *      f       decrease polygon offset factor
 *      B       increase polygon offset bias
 *      b       decrease polygon offset bias
 *	g	toggle grid drawing
 *	s	toggle smooth/flat shading
 *	n	toggle whether to use GL evaluators or GLU nurbs
 *	u	decr number of segments in U direction
 *	U	incr number of segments in U direction
 *	v	decr number of segments in V direction
 *	V	incr number of segments in V direction
 *	escape	quit
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ogl02.hxx"
//#include "test_glut.hxx"
//#include <stdio.h>
//#include <string.h>
//#include <stdlib.h>
#include <math.h>
//#include <GL/glut.h>
// for a frame count
#include "fps.hxx"
#ifndef _MSC_VER
#include <string.h> // for strlen()
#endif

#if (defined(GL_EXT_polygon_offset) && defined(ENABLE_EXTPOLY) && (ENABLE_EXTPOLY > 0))
#define  ADD_POLYGON_OFFSET   1
#pragma message("Note: ADD_POLYGON_OFFSET is DEFINED")
#else
#undef  ADD_POLYGON_OFFSET
#pragma message("Note: ADD_POLYGON_OFFSET is NOT DEFINED")
#endif

#define generic_keyboard   keyboard_pgm_exit
#define DEF_WID 600
#define DEF_HGT 600

//#define  ADD_FRAME_COUNTER
#undef  ADD_FRAME_COUNTER  // rather meaningless, since does not use 'Idle' callback
// to paint - just posts a 'redisplay' message...
#define  ADD_REDRAW_COUNTER  // rather meaningless, since does not use 'Idle' callback

// forward ref
static void key_help(void);

static float z_axis[] = {0.0, 0.0, 1.0};

// ==============================
bool use_bitmap_string = true;

static int winwidth = DEF_WID, winheight = DEF_HGT;
static GLUnurbsObj *nobj;
static GLuint surflist, gridlist;

static int useglunurbs = 0;
static int smooth = 1;
static GLboolean tracking = GL_FALSE;
static int showgrid = 1;
static int showsurf = 1;
static int fullscreen = 0;
static float modelmatrix[16];
static float factor = 0.5;
static float bias = 0.002;
static int usegments = 4;
static int vsegments = 4;

static int spindx, spindy;
static int startx, starty;
static int curx, cury;
static int prevx, prevy;       /* to get good deltas using glut */

static void redraw(void);
static void createlists(void);

/* Control points of the torus in Bezier form.  Can be rendered
   using OpenGL evaluators. */
static GLfloat torusbezierpts[] =
{
/* *INDENT-OFF* */
   4.0, 0.0, 0.0, 4.0, 2.0, 0.0, 1.0, 2.0, 3.0, 0.0, 1.0, 2.0,
   3.0, 0.0, 1.0, 2.0, 4.0, 0.0, 1.0, 2.0, 8.0, 0.0, 0.0, 4.0,
   8.0, 0.0, 0.0, 4.0, 4.0, 0.0,-1.0, 2.0, 3.0, 0.0,-1.0, 2.0,
   3.0, 0.0,-1.0, 2.0, 2.0, 0.0,-1.0, 2.0, 4.0, 0.0, 0.0, 4.0,
   2.0,-2.0, 0.0, 2.0, 1.0,-1.0, 0.5, 1.0, 1.5,-1.5, 0.5, 1.0,
   1.5,-1.5, 0.5, 1.0, 2.0,-2.0, 0.5, 1.0, 4.0,-4.0, 0.0, 2.0,
   4.0,-4.0, 0.0, 2.0, 2.0,-2.0,-0.5, 1.0, 1.5,-1.5,-0.5, 1.0,
   1.5,-1.5,-0.5, 1.0, 1.0,-1.0,-0.5, 1.0, 2.0,-2.0, 0.0, 2.0,
   0.0,-2.0, 0.0, 2.0, 0.0,-1.0, 0.5, 1.0, 0.0,-1.5, 0.5, 1.0,
   0.0,-1.5, 0.5, 1.0, 0.0,-2.0, 0.5, 1.0, 0.0,-4.0, 0.0, 2.0,
   0.0,-4.0, 0.0, 2.0, 0.0,-2.0,-0.5, 1.0, 0.0,-1.5,-0.5, 1.0,
   0.0,-1.5,-0.5, 1.0, 0.0,-1.0,-0.5, 1.0, 0.0,-2.0, 0.0, 2.0,
   0.0,-2.0, 0.0, 2.0, 0.0,-1.0, 0.5, 1.0, 0.0,-1.5, 0.5, 1.0,
   0.0,-1.5, 0.5, 1.0, 0.0,-2.0, 0.5, 1.0, 0.0,-4.0, 0.0, 2.0,
   0.0,-4.0, 0.0, 2.0, 0.0,-2.0,-0.5, 1.0, 0.0,-1.5,-0.5, 1.0,
   0.0,-1.5,-0.5, 1.0, 0.0,-1.0,-0.5, 1.0, 0.0,-2.0, 0.0, 2.0,
  -2.0,-2.0, 0.0, 2.0,-1.0,-1.0, 0.5, 1.0,-1.5,-1.5, 0.5, 1.0,
  -1.5,-1.5, 0.5, 1.0,-2.0,-2.0, 0.5, 1.0,-4.0,-4.0, 0.0, 2.0,
  -4.0,-4.0, 0.0, 2.0,-2.0,-2.0,-0.5, 1.0,-1.5,-1.5,-0.5, 1.0,
  -1.5,-1.5,-0.5, 1.0,-1.0,-1.0,-0.5, 1.0,-2.0,-2.0, 0.0, 2.0,
  -4.0, 0.0, 0.0, 4.0,-2.0, 0.0, 1.0, 2.0,-3.0, 0.0, 1.0, 2.0,
  -3.0, 0.0, 1.0, 2.0,-4.0, 0.0, 1.0, 2.0,-8.0, 0.0, 0.0, 4.0,
  -8.0, 0.0, 0.0, 4.0,-4.0, 0.0,-1.0, 2.0,-3.0, 0.0,-1.0, 2.0,
  -3.0, 0.0,-1.0, 2.0,-2.0, 0.0,-1.0, 2.0,-4.0, 0.0, 0.0, 4.0,
  -4.0, 0.0, 0.0, 4.0,-2.0, 0.0, 1.0, 2.0,-3.0, 0.0, 1.0, 2.0,
  -3.0, 0.0, 1.0, 2.0,-4.0, 0.0, 1.0, 2.0,-8.0, 0.0, 0.0, 4.0,
  -8.0, 0.0, 0.0, 4.0,-4.0, 0.0,-1.0, 2.0,-3.0, 0.0,-1.0, 2.0,
  -3.0, 0.0,-1.0, 2.0,-2.0, 0.0,-1.0, 2.0,-4.0, 0.0, 0.0, 4.0,
  -2.0, 2.0, 0.0, 2.0,-1.0, 1.0, 0.5, 1.0,-1.5, 1.5, 0.5, 1.0,
  -1.5, 1.5, 0.5, 1.0,-2.0, 2.0, 0.5, 1.0,-4.0, 4.0, 0.0, 2.0,
  -4.0, 4.0, 0.0, 2.0,-2.0, 2.0,-0.5, 1.0,-1.5, 1.5,-0.5, 1.0,
  -1.5, 1.5,-0.5, 1.0,-1.0, 1.0,-0.5, 1.0,-2.0, 2.0, 0.0, 2.0,
   0.0, 2.0, 0.0, 2.0, 0.0, 1.0, 0.5, 1.0, 0.0, 1.5, 0.5, 1.0,
   0.0, 1.5, 0.5, 1.0, 0.0, 2.0, 0.5, 1.0, 0.0, 4.0, 0.0, 2.0,
   0.0, 4.0, 0.0, 2.0, 0.0, 2.0,-0.5, 1.0, 0.0, 1.5,-0.5, 1.0,
   0.0, 1.5,-0.5, 1.0, 0.0, 1.0,-0.5, 1.0, 0.0, 2.0, 0.0, 2.0,
   0.0, 2.0, 0.0, 2.0, 0.0, 1.0, 0.5, 1.0, 0.0, 1.5, 0.5, 1.0,
   0.0, 1.5, 0.5, 1.0, 0.0, 2.0, 0.5, 1.0, 0.0, 4.0, 0.0, 2.0,
   0.0, 4.0, 0.0, 2.0, 0.0, 2.0,-0.5, 1.0, 0.0, 1.5,-0.5, 1.0,
   0.0, 1.5,-0.5, 1.0, 0.0, 1.0,-0.5, 1.0, 0.0, 2.0, 0.0, 2.0,
   2.0, 2.0, 0.0, 2.0, 1.0, 1.0, 0.5, 1.0, 1.5, 1.5, 0.5, 1.0,
   1.5, 1.5, 0.5, 1.0, 2.0, 2.0, 0.5, 1.0, 4.0, 4.0, 0.0, 2.0,
   4.0, 4.0, 0.0, 2.0, 2.0, 2.0,-0.5, 1.0, 1.5, 1.5,-0.5, 1.0,
   1.5, 1.5,-0.5, 1.0, 1.0, 1.0,-0.5, 1.0, 2.0, 2.0, 0.0, 2.0,
   4.0, 0.0, 0.0, 4.0, 2.0, 0.0, 1.0, 2.0, 3.0, 0.0, 1.0, 2.0,
   3.0, 0.0, 1.0, 2.0, 4.0, 0.0, 1.0, 2.0, 8.0, 0.0, 0.0, 4.0,
   8.0, 0.0, 0.0, 4.0, 4.0, 0.0,-1.0, 2.0, 3.0, 0.0,-1.0, 2.0,
   3.0, 0.0,-1.0, 2.0, 2.0, 0.0,-1.0, 2.0, 4.0, 0.0, 0.0, 4.0,
/* *INDENT-ON* */

};

/* Control points of a torus in NURBS form.  Can be rendered using
   the GLU NURBS routines. */
static GLfloat torusnurbpts[] =
{
/* *INDENT-OFF* */
   4.0, 0.0, 0.0, 4.0, 2.0, 0.0, 1.0, 2.0, 4.0, 0.0, 1.0, 2.0,
   8.0, 0.0, 0.0, 4.0, 4.0, 0.0,-1.0, 2.0, 2.0, 0.0,-1.0, 2.0,
   4.0, 0.0, 0.0, 4.0, 2.0,-2.0, 0.0, 2.0, 1.0,-1.0, 0.5, 1.0,
   2.0,-2.0, 0.5, 1.0, 4.0,-4.0, 0.0, 2.0, 2.0,-2.0,-0.5, 1.0,
   1.0,-1.0,-0.5, 1.0, 2.0,-2.0, 0.0, 2.0,-2.0,-2.0, 0.0, 2.0,
  -1.0,-1.0, 0.5, 1.0,-2.0,-2.0, 0.5, 1.0,-4.0,-4.0, 0.0, 2.0,
  -2.0,-2.0,-0.5, 1.0,-1.0,-1.0,-0.5, 1.0,-2.0,-2.0, 0.0, 2.0,
  -4.0, 0.0, 0.0, 4.0,-2.0, 0.0, 1.0, 2.0,-4.0, 0.0, 1.0, 2.0,
  -8.0, 0.0, 0.0, 4.0,-4.0, 0.0,-1.0, 2.0,-2.0, 0.0,-1.0, 2.0,
  -4.0, 0.0, 0.0, 4.0,-2.0, 2.0, 0.0, 2.0,-1.0, 1.0, 0.5, 1.0,
  -2.0, 2.0, 0.5, 1.0,-4.0, 4.0, 0.0, 2.0,-2.0, 2.0,-0.5, 1.0,
  -1.0, 1.0,-0.5, 1.0,-2.0, 2.0, 0.0, 2.0, 2.0, 2.0, 0.0, 2.0,
   1.0, 1.0, 0.5, 1.0, 2.0, 2.0, 0.5, 1.0, 4.0, 4.0, 0.0, 2.0,
   2.0, 2.0,-0.5, 1.0, 1.0, 1.0,-0.5, 1.0, 2.0, 2.0, 0.0, 2.0,
   4.0, 0.0, 0.0, 4.0, 2.0, 0.0, 1.0, 2.0, 4.0, 0.0, 1.0, 2.0,
   8.0, 0.0, 0.0, 4.0, 4.0, 0.0,-1.0, 2.0, 2.0, 0.0,-1.0, 2.0,
   4.0, 0.0, 0.0, 4.0,
/* *INDENT-ON* */

};

static void
norm(float v[3])
{
  float r;
  r = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
  v[0] /= r;
  v[1] /= r;
  v[2] /= r;
}

static void
cross(float v1[3], float v2[3], float result[3])
{
  result[0] = v1[1] * v2[2] - v1[2] * v2[1];
  result[1] = v1[2] * v2[0] - v1[0] * v2[2];
  result[2] = v1[0] * v2[1] - v1[1] * v2[0];
}

static float
length(float v[3])
{
  float r = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
  return r;
}

static void
move(int x, int y)
{
  prevx = curx;
  prevy = cury;
  curx = x;
  cury = y;
  if (curx != startx || cury != starty) {
    glutPostRedisplay();
    startx = curx;
    starty = cury;
  }
}

static void
button(int button, int state, int x, int y)
{
  if (button != GLUT_LEFT_BUTTON)
    return;
  switch (state) {
  case GLUT_DOWN:
    prevx = curx = startx = x;
    prevy = cury = starty = y;
    spindx = 0;
    spindy = 0;
    tracking = GL_TRUE;
    break;
  case GLUT_UP:
    /* If user released the button while moving the mouse, keep
     * spinning. */
    if (x != prevx || y != prevy) {
      spindx = x - prevx;
      spindy = y - prevy;
    }
    tracking = GL_FALSE;
    printf( "spin dx,dy %d,%d\n", spindx, spindy );
    break;
  }
}

/* Maintain a square window when resizing */
static void
reshape(int width, int height)
{
  int size;
  size = (width < height ? width : height);
  glViewport((width - size) / 2, (height - size) / 2, size, size);
  glutReshapeWindow(size, size);
  g_width = size;
  g_height = size;
  glutPostRedisplay();
}

static void
gridmaterials(void)
{
  static float front_mat_diffuse[] =  {1.0, 1.0, 0.4, 1.0};
  static float front_mat_ambient[] =  {0.1, 0.1, 0.1, 1.0};
  static float back_mat_diffuse[] =  {1.0, 0.0, 0.0, 1.0};
  static float back_mat_ambient[] =  {0.1, 0.1, 0.1, 1.0};

  glMaterialfv(GL_FRONT, GL_DIFFUSE, front_mat_diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT, front_mat_ambient);
  glMaterialfv(GL_BACK, GL_DIFFUSE, back_mat_diffuse);
  glMaterialfv(GL_BACK, GL_AMBIENT, back_mat_ambient);
}

static void
surfacematerials(void)
{
  static float front_mat_diffuse[] =  {0.2, 0.7, 0.4, 1.0};
  static float front_mat_ambient[] =  {0.1, 0.1, 0.1, 1.0};
  static float back_mat_diffuse[] =  {1.0, 1.0, 0.2, 1.0};
  static float back_mat_ambient[] =  {0.1, 0.1, 0.1, 1.0};

  glMaterialfv(GL_FRONT, GL_DIFFUSE, front_mat_diffuse);
  glMaterialfv(GL_FRONT, GL_AMBIENT, front_mat_ambient);
  glMaterialfv(GL_BACK, GL_DIFFUSE, back_mat_diffuse);
  glMaterialfv(GL_BACK, GL_AMBIENT, back_mat_ambient);
}

static void
reset_defaults(void)
{
   printf("r - reset defaults...\n");
   useglunurbs = 0;
   smooth = 1;
   glShadeModel(GL_SMOOTH);
   tracking = GL_FALSE;
   showgrid = 1;
   showsurf = 1;
   fullscreen = 0;
   factor = 0.5;
   bias = 0.002;
   usegments = 4;
   vsegments = 4;
   spindx = 0;
   spindy = 0;
   createlists();
}

static void
init_m16(void)
{
  static float ambient[] =  {0.0, 0.0, 0.0, 1.0};
  static float diffuse[] =  {1.0, 1.0, 1.0, 1.0};
  static float position[] = {90.0, 90.0, -150.0, 0.0};
  static float lmodel_ambient[] = {1.0, 1.0, 1.0, 1.0};

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(40.0, 1.0, 2.0, 200.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glGetFloatv(GL_MODELVIEW_MATRIX, modelmatrix);

  glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
  glLightfv(GL_LIGHT0, GL_POSITION, position);
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_AUTO_NORMAL);
  glFrontFace(GL_CCW);

  glEnable(GL_MAP2_VERTEX_4);
  glClearColor(0.25, 0.25, 0.5, 0.0);

#if (defined(ADD_POLYGON_OFFSET) && (ADD_POLYGON_OFFSET > 0))
  glPolygonOffsetEXT(factor, bias);
  glEnable(GL_POLYGON_OFFSET_EXT);
#endif

  nobj = gluNewNurbsRenderer();
#ifdef GLU_VERSION_1_1  /* New GLU 1.1 interface. */
  gluNurbsProperty(nobj, GLU_SAMPLING_METHOD, GLU_DOMAIN_DISTANCE);
#endif

  surflist = glGenLists(1);
  gridlist = glGenLists(1);
  createlists();
  key_help();
}

static void
drawmesh(void)
{
  int i, j;
  float *p;

  int up2p = 4;
  int uorder = 3, vorder = 3;
  int nu = 4, nv = 4;
  int vp2p = up2p * uorder * nu;

  for (j = 0; j < nv; j++) {
    for (i = 0; i < nu; i++) {
      p = torusbezierpts + (j * vp2p * vorder) + (i * up2p * uorder);
#ifdef ADD_POLYGON_OFFSET
      glPolygonOffsetEXT(factor, bias);
#endif
      glMap2f(GL_MAP2_VERTEX_4, 0.0, 1.0, up2p, 3, 0.0, 1.0, vp2p, 3, p);
      if (showsurf) {
        surfacematerials();
        glEvalMesh2(GL_FILL, 0, usegments, 0, vsegments);
      }
      if (showgrid) {
        gridmaterials();
        glEvalMesh2(GL_LINE, 0, usegments, 0, vsegments);
      }
    }
  }
}

static void
output(void * font, int x, int y, char *string)
{
  int len, i;
  glRasterPos2f(x, y);
  if( use_bitmap_string ) {
     // THIS IS AN EXTENDED freeglut functions
     // ===================
     // Noted using it GAINS about 700 frames per second
     // 1150 to 1850, a 60% increase, so it is MUCH faster
     // --------------------------------------------------
     // Draw a string of bitmapped characters. 
     // Parameters:
     //  font  A bitmapped font identifier.  
     //  string  A NUL-terminated ASCII string. 
     glutBitmapString( font, (const unsigned char *)string );
     // -----------------------------------------------------
  } else {
     len = (int) strlen(string);
     for (i = 0; i < len; i++) {
        // Draw a bitmapped character. 
        // Parameters:
        //  font  A bitmapped font identifier.  
        //  character  A character code. 
        // Draw a character at the current OpenGL raster position using 
        // a bitmapped font. The raster position is advanced by the 
        // width of the character.
        // Nothing is drawn, and the raster position is unaffected when either:
        //  character is out of range
        //  font is not a valid OpenGLUT bitmap font
        //  The current OpenGL raster position is invalid
        glutBitmapCharacter(font, string[i]);
     }
  }
}

#if   (defined(ADD_FRAME_COUNTER) || defined(ADD_REDRAW_COUNTER))
static void paint_fps2(void)
{
   char * cp = get_tmp_buf();
   sprintf(cp, "fps=%d v=%d u=%d", get_fps(), vsegments, usegments);
  	glPushMatrix();
	   /* clear any current modeling or viewing xforms */
	   glLoadIdentity(); 
	   /* save the Projection matrix */
	   glMatrixMode( GL_PROJECTION );
   	glPushMatrix();
		   /* make new world space to display text in */
		   glLoadIdentity();
   		glOrtho( 0.0, g_width, 0.0, g_height, -1, 1.0 );
         //glColor3f(1.0, 1.0, 1.0);
   		//glPushAttrib( GL_DEPTH_BUFFER_BIT );
            //glEnable(GL_TEXTURE_2D);
	   		/* don't want text to be hidden */
		   	//glDisable( GL_DEPTH_TEST ); 
			   //glColor3f( 1.0f, 1.0f, 1.0f ); // or her, text is black...
            output( GLUT_BITMAP_TIMES_ROMAN_10, g_width - 100, 15, cp );
            //glDisable(GL_TEXTURE_2D);
		   //glPopAttrib();
      glPopMatrix();
  	glMatrixMode( GL_MODELVIEW );
   glPopMatrix();
}

static void
paint_fps_NOT_USED(void)
{
   GLint winHeight, winWidth;
   char * cp = get_tmp_buf();
   sprintf(cp, "fps %d", get_fps() );
	/* save the ModelView matrix */
	glPushMatrix(); 
	/* clear any current modeling or viewing xforms */
	glLoadIdentity(); 
	/* save the Projection matrix */
	glMatrixMode( GL_PROJECTION );
	glPushMatrix();
		/* make new world space to display status in */
		glLoadIdentity();
		winWidth = glutGet(GLUT_WINDOW_WIDTH); 
		winHeight = glutGet(GLUT_WINDOW_HEIGHT);
		//glColor3f( 1.0f, 1.0f, 1.0f ); // does nothing here - text not seen
		//glOrtho( -0.5, winWidth-0.5, -0.5, winHeight-0.5, -1, 1.0 );
		glOrtho( 0.0, winWidth, 0.0, winHeight, -1, 1.0 );
		glColor3f( 1.0f, 1.0f, 1.0f );   // even here, text is BLACK
		glPushAttrib( GL_DEPTH_BUFFER_BIT );
			/* don't want text to be hidden */
			glDisable( GL_DEPTH_TEST ); 
			//glColor3f( 1.0f, 1.0f, 1.0f ); // or her, text is black...
         output( GLUT_BITMAP_TIMES_ROMAN_10, g_width - 60, 15, cp );
		glPopAttrib();
	/* restore matrixes */
	glPopMatrix();
	glMatrixMode( GL_MODELVIEW );
	glPopMatrix();
} /* paint_fps */

#endif // #ifdef  ADD_FRAME_COUNTER

static void
redraw(void)
{
  int dx, dy;
  float v[3], rot[3];
  float len, ang;

#ifdef ADD_REDRAW_COUNTER
  set_fps();
#endif // #ifdef ADD_FRAME_COUNTER
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glColor3f(1, 0, 0);

  if (tracking) {
    dx = curx - startx;
    dy = cury - starty;
  } else {
    dx = spindx;
    dy = spindy;
  }
  if (dx || dy) {
     // process the SPIN

    dy = -dy;
    v[0] = dx;
    v[1] = dy;
    v[2] = 0;

    len = length(v);
    ang = -len / 600 * 360;
    norm(v);
    cross(v, z_axis, rot);

    /* This is certainly not recommended for programs that care
       about performance or numerical stability: we concatenate
       the rotation onto the current modelview matrix and read
       the matrix back, thus saving ourselves from writing our
       own matrix manipulation routines.  */
    glLoadIdentity();
    glRotatef(ang, rot[0], rot[1], rot[2]);  // angle,x,y,z
    glMultMatrixf(modelmatrix);
    glGetFloatv(GL_MODELVIEW_MATRIX, modelmatrix);
  }
  glLoadIdentity();
  glTranslatef(0.0, 0.0, -10.0);
  glMultMatrixf(modelmatrix);

  if (useglunurbs) {
    if (showsurf)
      glCallList(surflist);
    if (showgrid)
      glCallList(gridlist);
  } else {
    glMapGrid2f(usegments, 0.0, 1.0, vsegments, 0.0, 1.0);
    drawmesh();
  }
#if   (defined(ADD_FRAME_COUNTER) || defined(ADD_REDRAW_COUNTER))
  paint_fps2();
#endif // #ifdef  ADD_FRAME_COUNTER
  glutSwapBuffers();
}

static void
usage(void)
{
  printf("usage: surfgrid [-f]\n");
  pgm_exit(-1);
}

static void
key_help(void)
{
   printf( " h  - this help.\n" );
#ifdef ADD_POLYGON_OFFSET
   printf( " p  - toggle GL_POLYGON_OFFSET_EXT\n" );
#endif
   printf( " F  - increase factor (%f).\n", factor );
   printf( " f  - decrease factor (%f).\n", factor );
   printf( " B  - increase bias   (%f).\n", bias   );
   printf( " b  - decrease bias   (%f).\n", bias   );
   printf( " g  - toggle show grid.  (%s).\n", (showgrid ? "on" : "off")  );
   printf( " n  - toggle useglunrubs (%s).\n", (useglunurbs ? "on" : "off")  );
   printf( " s  - toggle smooth      (%s).\n", (smooth ? "on" : "off")  );
   printf( " t  - toggle show surf.  (%s).\n", (showsurf ? "on" : "off")  );
   printf( " u  - decrease usegments.(%d).\n", usegments  );
   printf( " U  - increase usegments.(%d).\n", usegments  );
   printf( " v  - decrease vsegments.(%d).\n", vsegments  );
   printf( " V  - increase vsegments.(%d).\n", vsegments  );
   printf( " r  - reset defaults.\n" );
   printf( " ESC (q) = pgm_exit().\n"  );
}

/* what to do when a menu item is selected. This function also handles
   keystroke events.  */
static void
menu(int item)
{
  switch (item) {
  case 'p':
#ifdef ADD_POLYGON_OFFSET
    if (glIsEnabled(GL_POLYGON_OFFSET_EXT)) {
      glDisable(GL_POLYGON_OFFSET_EXT);
      printf("disabling polygon offset\n");
    } else {
      glEnable(GL_POLYGON_OFFSET_EXT);
      printf("enabling polygon offset\n");
    }
#endif
    break;
  case 'F':
    factor += 0.1;
    printf("F - factor: %8.4f\n", factor);
    break;
  case 'f':
    factor -= 0.1;
    printf("f - factor: %8.4f\n", factor);
    break;
  case 'B':
    bias += 0.0001;
    printf("B - bias:  %8.4f\n", bias);
    break;
  case 'b':
    bias -= 0.0001;
    printf("b - bias:  %8.4f\n", bias);
    break;
  case 'g':
    showgrid = !showgrid;
    printf( "g - show grid %s\n", (showgrid ? "On" : "Off") );
    break;
  case 'n':
    useglunurbs = !useglunurbs;
    printf( "n - use glu nurds %s\n", (useglunurbs ? "On" : "Off") );
    break;
  case 's':
    smooth = !smooth;
    if (smooth) {
      glShadeModel(GL_SMOOTH);
    } else {
      glShadeModel(GL_FLAT);
    }
    printf( "s - smooth %s\n", (smooth ? "On" : "Off") );
    break;
  case 't':
    showsurf = !showsurf;
    printf( "t - show surface %s\n", (showsurf ? "On" : "Off") );
    break;
  case 'u':
    usegments = (usegments < 2 ? 1 : usegments - 1);
    createlists();
    break;
  case 'U':
    usegments++;
    createlists();
    break;
  case 'v':
    vsegments = (vsegments < 2 ? 1 : vsegments - 1);
    createlists();
    break;
  case 'V':
    vsegments++;
    createlists();
    break;
  case 'h':
     key_help();
     break;
  case 'r':
  case 'R':
     reset_defaults();
     break;
  case '\033':         /* ESC key: quit */
    pgm_exit(0);
    break;
  }
  glutPostRedisplay();
}

/* ARGSUSED1 */
static void
key(unsigned char key, int x, int y)
{
  menu((int) key);
  generic_keyboard(key,x,y);
}

static void
animate(void)
{
#ifdef ADD_FRAME_COUNTER
   if( set_fps() )
      glutPostRedisplay();
#endif // #ifdef ADD_FRAME_COUNTER
  if (!tracking && (spindx != 0 || spindy != 0))
    glutPostRedisplay();
}

static void init_menu_m16(void)
{
  /* create a menu for the right mouse button */
  glutCreateMenu(menu);
#ifdef ADD_POLYGON_OFFSET
  glutAddMenuEntry("p: toggle polygon offset", 'p');
#endif
  glutAddMenuEntry("F: increase factor", 'F');
  glutAddMenuEntry("f: decrease factor", 'f');
  glutAddMenuEntry("B: increase bias", 'B');
  glutAddMenuEntry("b: decrease bias", 'b');
  glutAddMenuEntry("g: toggle grid", 'g');
  glutAddMenuEntry("s: toggle smooth shading", 's');
  glutAddMenuEntry("t: toggle surface", 't');
  glutAddMenuEntry("n: toggle GL evalutators/GLU nurbs", 'n');
  glutAddMenuEntry("u: decrement u segments", 'u');
  glutAddMenuEntry("U: increment u segments", 'U');
  glutAddMenuEntry("v: decrement v segments", 'v');
  glutAddMenuEntry("V: increment v segments", 'V');
  glutAddMenuEntry("<esc>: pgm_exit program", '\033');
  glutAttachMenu(GLUT_RIGHT_BUTTON);
}

// torus, put in motion by mouse click and move
//   case 36:
//      printf(" 36: glut_main16(argc,argv); // torus, put in motion by mouse click and move\n" );
int glut_main16(int argc, char **argv)
{
  int i;

  glutInit(&argc, argv);  /* initialize glut, processing
                             arguments */
  for (i = 1; i < argc; i++) {
    if (argv[i][0] == '-') {
      switch (argv[i][1]) {
      case 'f':
        fullscreen = 1;
        break;
      default:
        usage();
        break;
      }
    } else {
      usage();
    }
  }

  glutInitWindowSize(winwidth, winheight);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_DOUBLE);
  glutCreateWindow("surface grid on torus");

  init_menu_m16(); /* create a menu for the right mouse button */

  /* set callbacks */
  glutKeyboardFunc(key);
  glutDisplayFunc(redraw);
  glutReshapeFunc(reshape);
  glutMouseFunc(button);
  glutMotionFunc(move);
  glutIdleFunc(animate);

#ifdef ADD_POLYGON_OFFSET
  if (!glutExtensionSupported("GL_EXT_polygon_offset")) {
    printf("Warning: "
      "GL_EXT_polygon_offset not supported on this machine... "
      "trying anyway\n");
  }
#else
  printf("Warning: not compiled with GL_EXT_polygon_offset support.\n");
#endif

  init_m16();
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}

float circleknots[] =
{0.0, 0.0, 0.0, 0.25, 0.50, 0.50, 0.75, 1.0, 1.0, 1.0};

void
createlists(void)
{
   printf("createlists: %d usegments, %d vsegments\n", usegments, vsegments);
#ifdef GLU_VERSION_1_1  /* New GLU 1.1 interface. */
  gluNurbsProperty(nobj, GLU_U_STEP, (usegments - 1) * 4);
  gluNurbsProperty(nobj, GLU_V_STEP, (vsegments - 1) * 4);
  gluNurbsProperty(nobj, GLU_DISPLAY_MODE, GLU_FILL);
#endif

  glNewList(surflist, GL_COMPILE);
  surfacematerials();
  gluBeginSurface(nobj);
  gluNurbsSurface(nobj, 10, circleknots, 10, circleknots,
    4, 28, torusnurbpts, 3, 3, GL_MAP2_VERTEX_4);
  gluEndSurface(nobj);
  glEndList();

  gluNurbsProperty(nobj, GLU_DISPLAY_MODE, GLU_OUTLINE_POLYGON);
  glNewList(gridlist, GL_COMPILE);
  gridmaterials();
  gluBeginSurface(nobj);
  gluNurbsSurface(nobj, 10, circleknots, 10, circleknots,
    4, 28, torusnurbpts, 3, 3, GL_MAP2_VERTEX_4);
  gluEndSurface(nobj);
  glEndList();
}

// eof - ogl12 - taken from test_glut16.cxx
