// plib-fonts.cxx

#include "ogl02.hxx"
#include <plib/fnt.h>
#include "ogl-utils.hxx"
#ifdef _MSC_VER
#include <direct.h>  // for _getcwd()
#else
#define _getcwd getcwd
#endif
// see : http://sjbaker.org/steve/omniv/opengl_text.html

/* Declarations */
fntRenderer texout;
fntRenderer texout2;
static const char * fontfile2 = "Times-Roman.txf";
static const char * fontfile = "Courier.txf";

static bool done_font_init = false;
static fntTexFont * pfont = NULL;
static fntTexFont * pfont2 = NULL;
#define  MX_FONTS    128
#define  MY_FONT_SIZE   24
static int wrap_at = 30;
static int num_fonts = 3;

void toggle_plib_fonts(void)
{
   num_fonts++;
   if(num_fonts > 3 )
      num_fonts = 0;
}

void do_font_init(void)
{
   /* Load some fonts */
   // fntTexFont  TimesRoman ( fontfile ) ;
   // fntTexFont  Courier    ( "courier.txf" ) ;
   /* Select a font and pointsize to render with... */
   //texout . setFont      ( & TimesRoman ) ;
   //texout . setPointSize ( 24 ) ;
   char * cp = get_tmp_buf();
   
   strcpy(cp,fontfile);
   if( !file_exists(cp) ) {
      strcpy(cp,"data/");
      strcat(cp,fontfile);
      if( ! file_exists(cp) ) {
         printf( "ERROR: can not locate [%s], nor [%s] file... aborting...\n", fontfile, cp );
         exit(1);
      }
      pfont = new fntTexFont(cp);
      if( !pfont ) {
         printf( "ERROR: failed to load [%s] file... aborting...\n", cp );
         exit(1);
      }
   }
   strcpy(cp,fontfile2);
   if( !file_exists(cp) ) {
      strcpy(cp,"data/");
      strcat(cp,fontfile2);
      if( !file_exists(cp) ) {
         printf( "ERROR: can not locate [%s] file... aborting...\n", fontfile2 );
         exit(1);
      }
      pfont2 = new fntTexFont(cp);
      if( !pfont2 ) {
         printf( "ERROR: failed to load [%s] file... aborting...\n", fontfile2 );
         exit(1);
      }
   }
   
   texout . setFont      ( pfont ) ;
   texout . setPointSize ( MY_FONT_SIZE ) ;
   texout2 . setFont      ( pfont2 ) ;
   texout2 . setPointSize ( MY_FONT_SIZE ) ;
}

void print_font(int fps)
{
   GLfloat y = (float)(g_height - 30);
   GLfloat x = (float)(g_width - 160);
   char * cp = get_tmp_buf();
   int i, wrap, line;

   /* Print "Hello" and "World" */
   if(num_fonts > 0) {
   texout . begin () ;
     //texout . start2f ( 50.0f, 80.0f ) ;
     texout . start2f ( 50.0f, y) ;
     texout . puts ( "Hello" ) ;
     //texout . start2f ( 50.0f, 50.0f ) ;
     texout . start2f ( 50.0f, (y - 30.0) ) ;
     texout . puts ( "World" ) ;
   texout.end();
   }

   if(num_fonts > 1) {
   glColor3f(0.0, 1.0, 0.0);
   texout.begin();
     wrap = line = 0;
     line = 3;
     sprintf(cp, "Font: %s %d", fontfile, MY_FONT_SIZE );
     texout.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
     texout.puts(cp);
     line++;
     *cp = 0;
     wrap = 0;
     for( i = 32; i < MX_FONTS; i++ ) {
         sprintf(EndBuf(cp),"%c", i);
         wrap++;
         if(wrap >= wrap_at) {
            cp[wrap] = 0;
            texout.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
            texout.puts(cp);
            wrap = 0;
            line++;
            *cp = 0;
         }
     }
     if(wrap) {
            cp[wrap] = 0;
            texout.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
            texout.puts(cp);
            wrap = 0;
            line++;
            *cp = 0;
     }

  texout.end();
   }

   if(num_fonts > 2) {
  glColor3f(1.0, 1.0, 0.0);
  line++;

  texout2.begin();
     sprintf(cp, "Font: %s %d", fontfile2, MY_FONT_SIZE );
     texout2.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
     texout2.puts(cp);
     line++;
     *cp = 0;
     wrap = 0;
     for( i = 32; i < MX_FONTS; i++ ) {
         sprintf(EndBuf(cp),"%c", i);
         wrap++;
         if(wrap >= wrap_at) {
            cp[wrap] = 0;
            texout2.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
            texout2.puts(cp);
            wrap = 0;
            line++;
            *cp = 0;
         }
     }
     if(wrap) {
            cp[wrap] = 0;
            texout2.start2f ( 5.0f, (y - (float)(30 * line)) ) ;
            texout2.puts(cp);
            wrap = 0;
            line++;
            *cp = 0;
     }

   }

  glColor3f(1.0, 0.0, 0.0);
     line = 19;
     sprintf(cp, "fps: %d", fps);
     texout2.start2f ( x, (y - (float)(30 * line)) ) ;
     texout2.puts(cp);
     wrap = 0;
     line++;
     *cp = 0;

   texout2 . end () ;



}

void load_plib_font(void)
{
   char * cp = get_tmp_buf();
   strcpy(cp,fontfile);
   if( !file_exists(cp) ) {
      strcpy(cp,"data/");
      strcat(cp,fontfile);
      if( ! file_exists(cp) ) {
         printf( "ERROR: can not locate [%s], nor [%s] file... aborting...\n", fontfile, cp );
         exit(1);
      }
   }
   
   FILE * fp = fopen(cp, "rb");
   if(!fp) {
      _getcwd(cp, 256);
      printf("Application: %s, running in %s\n", g_progname, cp);
      printf("ERROR: can NOT locate font file [%s]! Aborting\n", fontfile );
      pgm_exit(1);
   }
   fclose(fp);
   
   
   strcpy(cp,fontfile2);
   if( !file_exists(cp) ) {
      strcpy(cp,"data/");
      strcat(cp,fontfile2);
      if( !file_exists(cp) ) {
         printf( "ERROR: can not locate [%s] nor [%s] file... aborting...\n", fontfile2, cp );
         exit(1);
      }
   }
   fp = fopen(cp, "rb");
   if(!fp) {
      _getcwd(cp, 256);
      printf("Application: %s, running in %s\n", g_progname, cp);
      printf("ERROR: can NOT locate font file [%s]! Aborting\n", fontfile2 );
      pgm_exit(1);
   }
   fclose(fp);

   do_font_init();
   done_font_init = true;
}

void test_plib_font(int fps)
{
   if( ! done_font_init ) {
      done_font_init = true;
      load_plib_font();
   }
   print_font(fps);
}

// eof plib-fonts.cxx
