// simpletxf.cxx
// from : http://web.mit.edu/course/6/6.837/src-backup/glut-3.7/progs/texfont/simpletxf.c
// 2009-06-16

/* Copyright (c) Mark J. Kilgard, 1997. */

/* This program is freely distributable without licensing fees  and is
   provided without guarantee or warrantee expressed or  implied. This
   program is -not- in the public domain. */

/* X compile line: cc -o simpletxf simpletxf.c texfont.c -lglut -lGLU -lGL -lXmu -lXext -lX11 -lm */

#include "ogl02.hxx"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <GL/glut.h>
#include "ogl-utils.hxx"
#include "TexFont.h"
#include "fps.hxx"

static int doubleBuffer = 1;
static char *filename = "default.txf";
static TexFont *txf;
static GLfloat angle = 20;
static int ms_wait = 50;
static void
idle(void)
{
   //set_fps();   // get rediculously high numbers
   if( ms_wait && check_timeout(ms_wait) )
      return;

   set_fps();
  angle += 4;
  glutPostRedisplay();
}

static void 
visible(int vis)
{
  if (vis == GLUT_VISIBLE)
    glutIdleFunc(idle);
  else
    glutIdleFunc(NULL);
}

// set locations for the 3 lines of text
static GLfloat y_location[3] = { 60.0, 0.0, -60.0 };

static void add_fps(void)
{
   static char _s_buf_fps[32];
  char *str = _s_buf_fps;
  sprintf(str,"fps %d", get_fps());
  glPushMatrix();
  glColor3f(0.0, 1.0, 0.0);
  //glTranslatef(0.0, -120.0, 0.0);
  glTranslatef(0.0, y_location[2], 0.0);
  //str = "fps 123456";
  txfRenderString(txf, str, (int) strlen(str));
  glPopMatrix();
}

//
// glRotate[d|f](angle, x, y, z) - definition
// angle - Specifies the angle of rotation, in degrees
// Specify the x, y, and z coordinates of a vector, respectively
// The current matrix (see glMatrixMode) is multiplied by a 
// rotation matrix with the product replacing the current matrix
//
// glTranslate[d|f]( x, y, z ) - difinition
// glTranslate produces a translation by	(x,y,z).  The current
// matrix (see glMatrixMode) is multiplied by this translation matrix

// glScale produces a nonuniform scaling along the x, y, and z axes. 
// The three parameters indicate the desired scale factor along each 
// of the three axes. 
// The current matrix (see glMatrixMode) is multiplied by this scale 
// matrix, and the product replaces the current matrix...

// glTranslatef( 0.0f, 0.0f, -distance);
static GLfloat distance = 0.0;
static GLfloat incidence = 0.0;

// from polar example
//	glTranslatef( 0.0f, 0.0f, -distance);
//	glRotatef( -twist, 0.0f, 0.0f, 1.0f);      // angle,x,y,z
//	glRotatef( -incidence, 1.0f, 0.0f, 0.0f);  // angle,x,y,z
//	glRotatef( -azimuth, 0.0f, 0.0f, 1.0f);    // angle,x,y,z
// here we have
//  glRotatef(angle, 0, 0, 1);  // angle, x, y, z
//  glTranslatef(-2.0, 0.0, -distance);
// so add
//	glRotatef( -incidence, 1.0, 0.0, 0.0);  // angle,x,y,z

#define AS_PER_ORIGINAL
#undef ADD_INCIDENCE

static void
display(void)
{
  const char *str;

  /* Clear the color buffer. */
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glPushMatrix();

#ifdef AS_PER_ORIGINAL
  // rotates aorund the approx center of 3 lines of text
  glRotatef(angle, 0, 0, 1);  // angle, x, y, z
#ifdef ADD_INCIDENCE
  glRotatef(-incidence, 1.0, 0.0, 0.0);   // this has NO effect - angle,x,y,z
#endif
  glTranslatef(-2.0, 0.0, -distance);
#else
  // this causes a rotation around the left side of text???
  // the x value sets the left/right location of the center
  glTranslatef(0.0, 0.0, -distance);
  glRotatef(angle, 0, 0, 1);  // angle, x, y, z
  glRotatef(-incidence, 1.0, 0.0, 0.0);   // this has NO effect - angle,x,y,z
#endif

  glScalef(1 / 60.0, 1 / 60.0, 1 / 60.0);

  glPushMatrix();
  glColor3f(0.0, 0.0, 1.0);
  glTranslatef(0.0, y_location[0], 0.0);
  str = "OpenGL is";
  txfRenderString(txf, str, (int) strlen(str));
  glPopMatrix();

  glPushMatrix();
  glColor3f(1.0, 0.0, 0.0);
  //glTranslatef(0.0, -60.0, 0.0);
  glTranslatef(0.0, y_location[1], 0.0);
  str = "the best.";
  txfRenderString(txf, str, (int) strlen(str));
  glPopMatrix();

  //put_fps(); // does NOT appear WHY WHY WHY ??? ??? ???
  add_fps();

  glPopMatrix();

  /* Swap the buffers if necessary. */
  if (doubleBuffer) {
    glutSwapBuffers();
  }
}

static int minifyMenu;

static void
minifySelect(int value)
{
  glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, value);
  glutPostRedisplay();
}

static int alphaMenu;

static void
alphaSelect(int value)
{
  switch (value) {
  case GL_ALPHA_TEST:
    glDisable(GL_BLEND);
    glEnable(GL_ALPHA_TEST);
    glAlphaFunc(GL_GEQUAL, 0.5);
    break;
  case GL_BLEND:
    glDisable(GL_ALPHA_TEST);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    break;
  case GL_NONE:
    glDisable(GL_ALPHA_TEST);
    glDisable(GL_BLEND);
    break;
  }
}

static void
mainSelect(int value)
{
  if (value == 666) {
    exit(0);
  }
}

// void gluPerspective( GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar )
// fovy	  Specifies the	field of view angle, in	degrees, in
//		  the y	direction.
// aspect  Specifies the	aspect ratio that determines the field
//		  of view in the x direction.  The aspect ratio	is the
//		  ratio	of x (width) to	y (height).
// zNear	  Specifies the	distance from the viewer to the	near
//		  clipping plane (always positive).
// zFar	  Specifies the	distance from the viewer to the	far
//		  clipping plane (always positive).

static void
init_tex03(void)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(60.0, 1.0, 0.1, 20.0); // fovy, aspect, zNear, zFar
  glMatrixMode(GL_MODELVIEW);
  // gluLookAt - define a viewing transformation
  gluLookAt(0.0, 0.0, 5.0, // eye x,y,z
    0.0, 0.0, 0.0,         // center x,y,z
    0.0, 1.0, 0.0);        // up x,y,z

  /* Use a gray background so the teximage with black backgrounds will show
     against showtxf's background. */
  glClearColor(0.5, 0.5, 0.5, 0.0);

  glEnable(GL_TEXTURE_2D);
  glEnable(GL_DEPTH_TEST);
  alphaSelect(GL_ALPHA_TEST);
  minifySelect(GL_NEAREST);

  txfEstablishTexture(txf, 0, GL_TRUE);

}

static void
menu_tex03(void)
{
  minifyMenu = glutCreateMenu(minifySelect);
  glutAddMenuEntry("Nearest", GL_NEAREST);
  glutAddMenuEntry("Linear", GL_LINEAR);
  glutAddMenuEntry("Nearest mipmap nearest", GL_NEAREST_MIPMAP_NEAREST);
  glutAddMenuEntry("Linear mipmap nearest", GL_LINEAR_MIPMAP_NEAREST);
  glutAddMenuEntry("Nearest mipmap linear", GL_NEAREST_MIPMAP_LINEAR);
  glutAddMenuEntry("Linear mipmap linear", GL_LINEAR_MIPMAP_LINEAR);

  alphaMenu = glutCreateMenu(alphaSelect);
  glutAddMenuEntry("Alpha testing", GL_ALPHA_TEST);
  glutAddMenuEntry("Alpha blending", GL_BLEND);
  glutAddMenuEntry("Nothing", GL_NONE);

  glutCreateMenu(mainSelect);
  glutAddSubMenu("Filtering", minifyMenu);
  glutAddSubMenu("Alpha", alphaMenu);
  glutAddMenuEntry("Quit", 666);
  glutAttachMenu(GLUT_RIGHT_BUTTON);
}

static void
key_help_tex03(void)
{
   printf( " h or ?  - this help.\n" );
   printf( " a       - Alpha testing(GL_ALPHA_TEST)\n" );
   printf( " b       - Alpha blending(GL_BLEND)\n" );
   printf( " n       - Alpha Nothing(GL_NONE)\n" );
   printf( " N       - Texture Filter Nearest(GL_NEAREST)\n" );
   printf( " L       - Texture Filter Linear(GL_LINEAR)\n" );
   printf( " m       - Nearest mipmap nearest(GL_NEAREST_MIPMAP_NEAREST)\n" );
   printf( " M       - Linear mipmap nearest(GL_LINEAR_MIPMAP_NEAREST)\n" );
   printf( " p       - Nearest mipmap linear(GL_NEAREST_MIPMAP_LINEAR)\n" );
   printf( " P       - Linear mipmap linear(GL_LINEAR_MIPMAP_LINEAR)\n" );
   printf( " t       - toggle through the above\n" );
   printf( " +/-     - increase/decrease rotation\n" );
   printf( " d/D     - increase/decrease distance. (near/far clipping)\n" );
   printf( " r/R     - reset.\n" );
   printf( " Right mouse button for context menu.\n" );
   printf( " q/Q/ESC - exit.\n" );
}

#define MX_TOGGLE 9
static int next_toggle = 0;
static unsigned char m_toggle[] = "abnNLmMpP";

static void
keyboard(unsigned char key, int x, int y)
{
   keyboard_pgm_exit(key,x,y);
   switch(key)
   {
   case 'h':
   case '?':
      key_help_tex03();
      break;

   case '+':
      if(ms_wait) {
         ms_wait--;
         printf("+ ms_wait is %d\n", ms_wait);
      } else {
         printf("+ ms_wait is ZERO!\n");
      }
      break;
   case '-':
      ms_wait++;
      printf("- ms_wait is %d\n", ms_wait);
      break;
   case 'r':
   case 'R':
      ms_wait = 50;
      distance = 0.0;
      angle = 20.0;
      printf("r/R - reset ms_wait to %d, angle 20.0, distance 0.0\n", ms_wait);
      keyboard('a', x, y); // alphaSelect(GL_ALPHA_TEST);
      keyboard('N', x, y); // minifySelect(GL_NEAREST);
      break;
   case 'a':
      alphaSelect(GL_ALPHA_TEST);
      printf( "a - Alpha testing(GL_ALPHA_TEST)\n" );
      break;
   case 'b':
      alphaSelect(GL_BLEND);
      printf( "b - Alpha blending(GL_BLEND)\n" );
      break;
   case 'n':
      alphaSelect(GL_NONE);
      printf( "n - Alpha Nothing(GL_NONE)\n" );
      break;
   case 'N':
      minifySelect(GL_NEAREST);
      printf( "N - Texture Filter Nearest(GL_NEAREST)\n" );
      break;
   case 'L':
      minifySelect(GL_LINEAR);
      printf( "L - Texture Filter Linear(GL_LINEAR)\n" );
      break;
   case 'm':
      minifySelect(GL_NEAREST_MIPMAP_NEAREST);
      printf( "m - Nearest mipmap nearest(GL_NEAREST_MIPMAP_NEAREST)\n" );
      break;
   case 'M':
      minifySelect(GL_LINEAR_MIPMAP_NEAREST);
      printf( "M - Linear mipmap nearest(GL_LINEAR_MIPMAP_NEAREST)\n" );
      break;
   case 'p':
      minifySelect(GL_NEAREST_MIPMAP_LINEAR);
      printf( "p - Nearest mipmap linear(GL_NEAREST_MIPMAP_LINEAR)\n" );
      break;
   case 'P':
      minifySelect(GL_LINEAR_MIPMAP_LINEAR);
      printf( "P - Linear mipmap linear(GL_LINEAR_MIPMAP_LINEAR)\n" );
      break;
   case 't':
      printf( "t - toggle ");
      keyboard(m_toggle[next_toggle], x, y);
      next_toggle++;
      if(next_toggle >= MX_TOGGLE)
         next_toggle = 0;
      break;
   case 'd':
      distance += 0.1;
      printf("d - increase distance %0.1f\n", distance );
      break;
   case 'D':
      distance -= 0.1;
      printf("D - decrease distance %0.1f\n", distance );
      break;
#ifdef ADD_INCIDENCE
   case 'i':
      incidence += 0.1;
      printf("i - increase incidence %0.1f\n", incidence );
      break;
   case 'I':
      incidence -= 0.1;
      printf("I - decrease incidence %0.1f\n", incidence );
      break;
#endif
   }
}

// Notifying the press of arrow key by modifying the relavent variables.
static void 
ProcessArrowKey(int Key, int x, int y)
{
   switch(Key)
   {
   case GLUT_KEY_LEFT :
#if 0
      if (TurnRight == true)
         TurnRight = false;
      TurnLeft = true;
      NextRotation = true;
      RotationLeftRate++;
      RotationRightRate = 0;
#endif
      break;
   case GLUT_KEY_RIGHT :
#if 0
      if (TurnLeft == true)
         TurnLeft = false;
      TurnRight = true;
      NextRotation = true;
      RotationRightRate++;
      RotationLeftRate = 0;
#endif
      break;
   }
}


//  case 40:
//  return main_tex03(argc, argv); // display text 'OpenGL is best'
int
main_tex03(int argc, char **argv)
{
  int i;
  char * cp = get_tmp_buf();
  
  glutInit(&argc, argv);
  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i], "-sb")) {
      doubleBuffer = 0;
    } else {
      filename = argv[i];
    }
  }
  if (filename == NULL) {
    fprintf(stderr, "usage: show [GLUT-options] [-sb] txf-file\n");
    pgm_exit(1);
  }
  strcpy(cp,filename);
  if( !file_exists(cp) ) {
     strcpy(cp,"data/");
     strcat(cp,filename);
     if( !file_exists(cp) ) {
        printf( "ERROR: can not locate [%s] nor [%s] file... aborting...\n", filename, cp );
        exit(1);
     }
  }
  txf = txfLoadFont(cp);
  if (txf == NULL) {
    fprintf(stderr, "Problem loading %s\n", cp);
    pgm_exit(1);
  }

  if (doubleBuffer) {
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
  } else {
    glutInitDisplayMode(GLUT_RGB | GLUT_SINGLE | GLUT_DEPTH);
  }
  glutInitWindowSize(300, 300);
  glutCreateWindow("texfont");
  glutDisplayFunc(display);
  glutKeyboardFunc(keyboard);
  glutVisibilityFunc(visible);
  glutSpecialFunc(ProcessArrowKey);
  init_tex03();
  menu_tex03();
  key_help_tex03();
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}

// eof - simpletxf.cxx
