// winport.h
#ifndef _winport_h_
#define _winport_h_

/* some GLUE code, just for WIN32 */
#define  DT_DIR      1

struct dirent{
	int  d_namlen;
   unsigned short d_reclen;
	unsigned char d_type;
	char d_name[256];
};

struct _DIR {
	HANDLE hfind;
	WIN32_FIND_DATA fd;
	char search[264];
	struct dirent de;
	int	is_first;
};

typedef struct _DIR DIR;

extern DIR * opendir(const char * dir );
extern struct dirent * readdir(DIR * dp);
extern int closedir(DIR * dp);

/* allow -@input.fil command input */
extern void input_response_file (int *pargc, char ***pargv);
extern void term_response_file( void );

struct timezone 
{
  int  tz_minuteswest; /* minutes W of Greenwich */
  int  tz_dsttime;     /* type of dst correction */
};
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int geteuid( void );   /* not really! return 0 to signal root!! */


/* REALLY ONLY FOR DEBUG - !NDEBUG */
extern void print_hex( char * buf, int sz, char * msg, __int64 offset );
extern void show_arguments(int argc, char ** argv);

#endif // _winport_h_
// eof - winport.h
