/*
   config.h - Hand crafted for Win32 - 20080809 
   to port source 11/08/2008 14:31 2,822,777 tar-1.20.tar.gz
   to Windows 32-bit, using MSVC8 (2005) - Geoff McLane
*/
#ifndef  _WIN32_CONFIG_H_
#define  _WIN32_CONFIG_H_

#ifndef NDEBUG
#define  DBGV5 5     /* if -vvvvv, give more info */
#undef  HEAVY_DEBUG_DELETE
#endif /* !NDEBUG */

/* Define to the number of bits in type 'ptrdiff_t'. */
#define BITSIZEOF_PTRDIFF_T   32

/* Define to the number of bits in type 'sig_atomic_t'. */
#define BITSIZEOF_SIG_ATOMIC_T   32

/* Define to the number of bits in type 'size_t'. */
#define BITSIZEOF_SIZE_T   32

/* Define to the number of bits in type 'wchar_t'. */
#define BITSIZEOF_WCHAR_T   16

/* Define to the number of bits in type 'wint_t'. */
#define BITSIZEOF_WINT_T   32

/* Define if chown is not POSIX compliant regarding IDs of -1. */
#undef CHOWN_FAILS_TO_HONOR_ID_OF_NEGATIVE_ONE

/* Define if chown modifies symlinks. */
#undef CHOWN_MODIFIES_SYMLINK

/* Define to one of `_getb67', `GETB67', `getb67' for Cray-2 and Cray-YMP
   systems. This function is required for `alloca.c' support on those systems.
   */
#undef CRAY_STACKSEG_END

/* Define to 1 if using `alloca.c'. */
#undef C_ALLOCA

/* Define to a string giving the full name of the default archive file. */
#undef DEFAULT_ARCHIVE

/* By default produce archives of this format */
#undef DEFAULT_ARCHIVE_FORMAT

/* Define to a number giving the default blocking size for archives. */
#undef DEFAULT_BLOCKING

/* Define to a default quoting style (see lib/quoteargs.c for the list) */
#undef DEFAULT_QUOTING_STYLE

/* Define full file name of rmt program. */
#define DEFAULT_RMT_COMMAND   "none in win32"

/* Define to 1 if density may be indicated by [lmh] at end of device. */
#undef DENSITY_LETTER

/* Define to a string giving the prefix of the default device, without the
   part specifying the unit and density. */
#undef DEVICE_PREFIX

/* the name of the file descriptor member of DIR */
#undef DIR_FD_MEMBER_NAME

#ifdef DIR_FD_MEMBER_NAME
# define DIR_TO_FD(Dir_p) ((Dir_p)->DIR_FD_MEMBER_NAME)
#else
# define DIR_TO_FD(Dir_p) -1
#endif


/* Define to 1 if // is a file system root distinct from /. */
#undef DOUBLE_SLASH_IS_DISTINCT_ROOT

/* Define if struct dirent has a member d_ino that actually works. */
#undef D_INO_IN_DIRENT

/* Define to 1 if translation of program messages to the user's native
   language is requested. */
#undef ENABLE_NLS

/* Define as good substitute value for EOVERFLOW. */
/* windows errno.h has E2BIG */
#define EOVERFLOW    E2BIG

/* Define if gnulib's fchdir() replacement is used. */
#undef FCHDIR_REPLACEMENT

/* Define on systems for which file names may have a so-called `drive letter'
   prefix, define this to compute the length of that prefix, including the
   colon. */
#define FILE_SYSTEM_ACCEPTS_DRIVE_LETTER_PREFIX 1

/* Define if the backslash character may also serve as a file name component
   separator. */
#define FILE_SYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR  1

/* Define if a drive letter prefix denotes a relative path if it is not
   followed by a file name component separator. */
#define FILE_SYSTEM_DRIVE_PREFIX_CAN_BE_RELATIVE   1

/* Define if gettimeofday clobbers the localtime buffer. */
#define GETTIMEOFDAY_CLOBBERS_LOCALTIME   1

/* Define to make the limit macros in <stdint.h> visible. */
#undef GL_TRIGGER_STDC_LIMIT_MACROS

/* Define to 1 when using the gnulib module close-stream. */
#undef GNULIB_CLOSE_STREAM

/* Define to 1 when using the gnulib module fcntl-safer. */
#undef GNULIB_FCNTL_SAFER

/* Define to 1 to add extern declaration of program_invocation_name to argp.h
   */
#undef GNULIB_PROGRAM_INVOCATION_NAME

/* Define to 1 to add extern declaration of program_invocation_short_name to
   argp.h */
#define GNULIB_PROGRAM_INVOCATION_SHORT_NAME 1

/* Define to 1 if you have the `alarm' function. */
#undef HAVE_ALARM

/* Define to 1 if you have 'alloca' after including <alloca.h>, a header that
   may be supplied by this distribution. */
#undef HAVE_ALLOCA

/* Define HAVE_ALLOCA_H for backward compatibility with older code that
   includes <alloca.h> only if HAVE_ALLOCA_H is defined. */
#undef HAVE_ALLOCA_H

/* Define to 1 if you have the <bp-sym.h> header file. */
#undef HAVE_BP_SYM_H

/* Define to 1 if you have the `btowc' function. */
#undef HAVE_BTOWC

/* Define to 1 if you have the `canonicalize_file_name' function. */
#undef HAVE_CANONICALIZE_FILE_NAME

/* Define to 1 if you have the MacOS X function CFLocaleCopyCurrent in the
   CoreFoundation framework. */
#undef HAVE_CFLOCALECOPYCURRENT

/* Define to 1 if you have the MacOS X function CFPreferencesCopyAppValue in
   the CoreFoundation framework. */
#undef HAVE_CFPREFERENCESCOPYAPPVALUE

/* Define to 1 if your system has a working `chown' function. */
#undef HAVE_CHOWN

/* Define to 1 if you have the `chsize' function. */
#undef HAVE_CHSIZE

/* Define to 1 if you have the `clock_gettime' function. */
#undef HAVE_CLOCK_GETTIME

/* Define to 1 if you have the `clock_settime' function. */
#undef HAVE_CLOCK_SETTIME

/* Define if you have compound literals. */
#undef HAVE_COMPOUND_LITERALS

/* Define if the GNU dcgettext() function is already present or preinstalled.
   */
#undef HAVE_DCGETTEXT

/* Define to 1 if you have the declaration of `canonicalize_file_name', and to
   0 if you don't. */
#define HAVE_DECL_CANONICALIZE_FILE_NAME  0

/* Define to 1 if you have the declaration of `clearerr_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_CLEARERR_UNLOCKED 0

/* Define to 1 if you have the declaration of `dirfd', and to 0 if you don't.
   */
#define HAVE_DECL_DIRFD 0

/* Define to 1 if you have the declaration of `feof_unlocked', and to 0 if you
   don't. */
#define HAVE_DECL_FEOF_UNLOCKED  0

/* Define to 1 if you have the declaration of `ferror_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FERROR_UNLOCKED   0

/* Define to 1 if you have the declaration of `fflush_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FFLUSH_UNLOCKED   0

/* Define to 1 if you have the declaration of `fgets_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FGETS_UNLOCKED 0

/* Define to 1 if you have the declaration of `fputc_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FPUTC_UNLOCKED 0

/* Define to 1 if you have the declaration of `fputs_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FPUTS_UNLOCKED 0

/* Define to 1 if you have the declaration of `fread_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FREAD_UNLOCKED 0

/* Define to 1 if you have the declaration of `fwrite_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_FWRITE_UNLOCKED   0

/* Define to 1 if you have the declaration of `getchar_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_GETCHAR_UNLOCKED  0

/* Define to 1 if you have the declaration of `getcwd', and to 0 if you don't.
   */
#define HAVE_DECL_GETCWD   1

/* Define to 1 if you have the declaration of `getc_unlocked', and to 0 if you
   don't. */
#define HAVE_DECL_GETC_UNLOCKED  0

/* Define to 1 if you have the declaration of `getdelim', and to 0 if you
   don't. */
#define HAVE_DECL_GETDELIM 0

/* Define to 1 if you have the declaration of `getenv', and to 0 if you don't.
   */
#define HAVE_DECL_GETENV   1

/* Define to 1 if you have the declaration of `getgrgid', and to 0 if you
   don't. */
#define HAVE_DECL_GETGRGID 0

/* Define to 1 if you have the declaration of `getline', and to 0 if you
   don't. */
#define HAVE_DECL_GETLINE  0

/* Define to 1 if you have the declaration of `getpwuid', and to 0 if you
   don't. */
#define HAVE_DECL_GETPWUID 0

/* Define to 1 if you have the declaration of `imaxabs', and to 0 if you
   don't. */
#define HAVE_DECL_IMAXABS  0

/* Define to 1 if you have the declaration of `imaxdiv', and to 0 if you
   don't. */
#define HAVE_DECL_IMAXDIV  0

/* Define to 1 if you have the declaration of `isblank', and to 0 if you
   don't. */
#define HAVE_DECL_ISBLANK  0

/* Define to 1 if you have the declaration of `memrchr', and to 0 if you
   don't. */
#define HAVE_DECL_MEMRCHR  0

/* Define to 1 if you have the declaration of `mkdir', and to 0 if you don't.
   */
#define HAVE_DECL_MKDIR    1

/* Define if program_invocation_name is declared */
#undef HAVE_DECL_PROGRAM_INVOCATION_NAME

/* Define if program_invocation_short_name is declared */
#undef HAVE_DECL_PROGRAM_INVOCATION_SHORT_NAME

/* Define to 1 if you have the declaration of `putchar_unlocked', and to 0 if
   you don't. */
#define HAVE_DECL_PUTCHAR_UNLOCKED  0

/* Define to 1 if you have the declaration of `putc_unlocked', and to 0 if you
   don't. */
#define HAVE_DECL_PUTC_UNLOCKED  0

/* Define to 1 if you have the declaration of `strdup', and to 0 if you don't.
   */
#define HAVE_DECL_STRDUP   1

/* Define to 1 if you have the declaration of `strerror', and to 0 if you
   don't. */
#define HAVE_DECL_STRERROR 0

/* Define to 1 if you have the declaration of `strerror_r', and to 0 if you
   don't. */
#define HAVE_DECL_STRERROR_R  0

/* Define to 1 if you have the declaration of `strncasecmp', and to 0 if you
   don't. */
#define HAVE_DECL_STRNCASECMP 0

/* Define to 1 if you have the declaration of `strndup', and to 0 if you
   don't. */
#define HAVE_DECL_STRNDUP  0

/* Define to 1 if you have the declaration of `strnlen', and to 0 if you
   don't. */
#define HAVE_DECL_STRNLEN  0

/* Define to 1 if you have the declaration of `strtoimax', and to 0 if you
   don't. */
#define HAVE_DECL_STRTOIMAX   0

/* Define to 1 if you have the declaration of `strtoll', and to 0 if you
   don't. */
#define HAVE_DECL_STRTOLL  0

/* Define to 1 if you have the declaration of `strtoull', and to 0 if you
   don't. */
#define HAVE_DECL_STRTOULL 0

/* Define to 1 if you have the declaration of `strtoumax', and to 0 if you
   don't. */
#define HAVE_DECL_STRTOUMAX   0

/* Define to 1 if you have the declaration of `time', and to 0 if you don't.
   */
#define HAVE_DECL_TIME  1

/* Define to 1 if you have the declaration of `tzname', and to 0 if you don't.
   */
#define HAVE_DECL_TZNAME   0

/* Define to 1 if you have the declaration of `vsnprintf', and to 0 if you
   don't. */
#define HAVE_DECL_VSNPRINTF   1

/* Define to 1 if you have the declaration of `wcwidth', and to 0 if you
   don't. */
#define HAVE_DECL_WCWIDTH  0

/* Define to 1 if you have the declaration of `_snprintf', and to 0 if you
   don't. */
#define HAVE_DECL__SNPRINTF 1

/* Define to 1 if you have the declaration of `__fpending', and to 0 if you
   don't. */
#define HAVE_DECL___FPENDING  0

/* Define to 1 if you have the <dirent.h> header file. */
#undef HAVE_DIRENT_H

/* Define to 1 if you have the `dirfd' function. */
#undef HAVE_DIRFD

/* Define to 1 if you have the `dup2' function. */
#undef HAVE_DUP2

/* Define if you have the declaration of environ. */
#undef HAVE_ENVIRON_DECL

/* Define to 1 if you have the `fchdir' function. */
#undef HAVE_FCHDIR

/* Define to 1 if you have the `fchmodat' function. */
#undef HAVE_FCHMODAT

/* Define to 1 if you have the <fcntl.h> header file. */
#define HAVE_FCNTL_H 1

/* Define to 1 if you have the `fdopendir' function. */
#undef HAVE_FDOPENDIR

/* Define to 1 if you have the <features.h> header file. */
#undef HAVE_FEATURES_H

/* Define to 1 if you have the <float.h> header file. */
#undef HAVE_FLOAT_H

/* Define to 1 if you have the `flockfile' function. */
#undef HAVE_FLOCKFILE

/* Define to 1 if you have the `fsync' function. */
#undef HAVE_FSYNC

/* Define to 1 if you have the `ftruncate' function. */
#undef HAVE_FTRUNCATE

/* Define to 1 if you have the `funlockfile' function. */
#undef HAVE_FUNLOCKFILE

/* Define to 1 if you have the `futimes' function. */
#undef HAVE_FUTIMES

/* Define to 1 if you have the `futimesat' function. */
#undef HAVE_FUTIMESAT

/* Define to 1 if you have the `getcwd' function. */
#define HAVE_GETCWD  1

/* Define to 1 if you have the `getdelim' function. */
#undef HAVE_GETDELIM

/* Define to 1 if you have the `getdtablesize' function. */
#undef HAVE_GETDTABLESIZE

/* Define to 1 if you have the <getopt.h> header file. */
#undef HAVE_GETOPT_H

/* Define to 1 if you have the `getopt_long_only' function. */
#undef HAVE_GETOPT_LONG_ONLY

/* Define to 1 if you have the `getpagesize' function. */
#undef HAVE_GETPAGESIZE

/* Define if the GNU gettext() function is already present or preinstalled. */
#undef HAVE_GETTEXT

/* Define to 1 if you have the `gettimeofday' function. */
#define HAVE_GETTIMEOFDAY  1

/* Define if you have the iconv() function and it works. */
#undef HAVE_ICONV

/* Define to 1 if you have the <iconv.h> header file. */
#undef HAVE_ICONV_H

/* Define if your compiler supports the #include_next directive. */
#undef HAVE_INCLUDE_NEXT

/* Define to 1 if the compiler supports one of the keywords 'inline',
   '__inline__', '__inline' and effectively inlines functions marked as such.
   */
#define HAVE_INLINE  0

/* Define if you have the 'intmax_t' type in <stdint.h> or <inttypes.h>. */
#undef HAVE_INTMAX_T

/* Define to 1 if you have the <inttypes.h> header file. */
/* well, sort of ... */
#define HAVE_INTTYPES_H 1

/* Define if <inttypes.h> exists, doesn't clash with <sys/types.h>, and
   declares uintmax_t. */
#undef HAVE_INTTYPES_H_WITH_UINTMAX

/* Define to 1 if you have the <io.h> header file. */
#define HAVE_IO_H 1

/* Define to 1 if you have the `isblank' function. */
#undef HAVE_ISBLANK

/* Define to 1 if you have the `iswcntrl' function. */
#undef HAVE_ISWCNTRL

/* Define to 1 if you have the `iswctype' function. */
#undef HAVE_ISWCTYPE

/* Define if you have <langinfo.h> and nl_langinfo(CODESET). */
#undef HAVE_LANGINFO_CODESET

/* Define to 1 if you have the `lchmod' function. */
#undef HAVE_LCHMOD

/* Define to 1 if you have the `lchown' function. */
#undef HAVE_LCHOWN

/* Define to 1 if you have the <linewrap.h> header file. */
#undef HAVE_LINEWRAP_H

/* Define to 1 if you have the <linux/fd.h> header file. */
#undef HAVE_LINUX_FD_H

/* Define to 1 if you have the <locale.h> header file. */
#undef HAVE_LOCALE_H

/* Define to 1 if you support file names longer than 14 characters. */
#define HAVE_LONG_FILE_NAMES  1

/* Define if you have the 'long long' type. */
#define HAVE_LONG_LONG  1

/* Define to 1 if the system has the type `long long int'. */
#undef HAVE_LONG_LONG_INT

/* Define to 1 if you have the `lstat' function. */
#undef HAVE_LSTAT

/* Define to 1 if your system has a GNU libc compatible `malloc' function, and
   to 0 otherwise. */
#define HAVE_MALLOC  1

/* Define if the 'malloc' function is POSIX compliant. */
#undef HAVE_MALLOC_POSIX

/* Define to 1 if you have the `mbrtowc' function. */
#define HAVE_MBRTOWC 1

/* Define to 1 if you have the `mbsinit' function. */
#define HAVE_MBSINIT 1

/* Define to 1 if you have the `mbsrtowcs' function. */
#define HAVE_MBSRTOWCS 1

/* Define to 1 if <wchar.h> declares mbstate_t. */
#define HAVE_MBSTATE_T 1

/* Define to 1 if you have the `memchr' function. */
#define HAVE_MEMCHR 1

/* Define to 1 if you have the <memory.h> header file. */
#define HAVE_MEMORY_H   1

/* Define to 1 if you have the `mempcpy' function. */
#undef HAVE_MEMPCPY

/* Define to 1 if you have the `memrchr' function. */
#undef HAVE_MEMRCHR

/* Define to 1 if you have the `memset' function. */
#define HAVE_MEMSET  1

/* Define to 1 if you have the `mkdirat' function. */
#undef HAVE_MKDIRAT

/* Define to 1 if you have the `mkdtemp' function. */
#undef HAVE_MKDTEMP

/* Define to 1 if you have the `mkfifo' function. */
#undef HAVE_MKFIFO

/* Define to 1 if you have the `nanotime' function. */
#undef HAVE_NANOTIME

/* Define to 1 if you have the <ndir.h> header file, and it defines `DIR'. */
#undef HAVE_NDIR_H

/* Define to 1 if you have the <netdb.h> header file. */
#undef HAVE_NETDB_H

/* Define to 1 if you have the <net/errno.h> header file. */
#undef HAVE_NET_ERRNO_H

/* Define to 1 if libc includes obstacks. */
#undef HAVE_OBSTACK

/* Define to 1 if you have the `openat' function. */
#undef HAVE_OPENAT

/* Define to 1 if you have the <OS.h> header file. */
#undef HAVE_OS_H

/* Define to 1 if getcwd works, except it sometimes fails when it shouldn't,
   setting errno to ERANGE, ENAMETOOLONG, or ENOENT. If __GETCWD_PREFIX is not
   defined, it doesn't matter whether HAVE_PARTLY_WORKING_GETCWD is defined.
   */
#undef HAVE_PARTLY_WORKING_GETCWD

/* Define to 1 if you have the `pathconf' function. */
#undef HAVE_PATHCONF

/* Define to 1 if you have the `pipe' function. */
#undef HAVE_PIPE

/* Define to 1 if you have the <priv.h> header file. */
#undef HAVE_PRIV_H

/* Define if program_invocation_name is defined */
#undef HAVE_PROGRAM_INVOCATION_NAME

/* Define if program_invocation_short_name is defined */
#undef HAVE_PROGRAM_INVOCATION_SHORT_NAME

/* Define to 1 if the system has the type `ptrdiff_t'. */
#undef HAVE_PTRDIFF_T

/* Define to 1 if you have the `readlink' function. */
#undef HAVE_READLINK

/* Define if the 'realloc' function is POSIX compliant. */
#undef HAVE_REALLOC_POSIX

/* Define to 1 if you have the `rmdir' function. */
#undef HAVE_RMDIR

/* Define to 1 if you have the `rpmatch' function. */
#undef HAVE_RPMATCH

/* Define to 1 if you have the <search.h> header file. */
#undef HAVE_SEARCH_H

/* Define to 1 if you have the `setenv' function. */
#undef HAVE_SETENV

/* Define to 1 if you have the `setlocale' function. */
#undef HAVE_SETLOCALE

/* Define to 1 if you have the <sgtty.h> header file. */
#undef HAVE_SGTTY_H

/* Define to 1 if 'sig_atomic_t' is a signed integer type. */
#undef HAVE_SIGNED_SIG_ATOMIC_T

/* Define to 1 if 'wchar_t' is a signed integer type. */
#undef HAVE_SIGNED_WCHAR_T

/* Define to 1 if 'wint_t' is a signed integer type. */
#undef HAVE_SIGNED_WINT_T

/* Define to 1 if you have the `sleep' function. */
#undef HAVE_SLEEP

/* Define to 1 if you have the `snprintf' function. */
#define HAVE_SNPRINTF   1

/* Define to 1 if stdbool.h conforms to C99. */
#define HAVE_STDBOOL_H  0

/* Define to 1 if you have the <stdint.h> header file. */
#define HAVE_STDINT_H   0

/* Define if <stdint.h> exists, doesn't clash with <sys/types.h>, and declares
   uintmax_t. */
#undef HAVE_STDINT_H_WITH_UINTMAX

/* Define to 1 if you have the <stdio_ext.h> header file. */
#undef HAVE_STDIO_EXT_H

/* Define to 1 if you have the <stdio.h> header file. */
#define HAVE_STDIO_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H   1

/* Define to 1 if you have the `stpcpy' function. */
#undef HAVE_STPCPY

/* Define to 1 if you have the `strcasecmp' function. */
#undef HAVE_STRCASECMP

/* Define to 1 if you have the `strchrnul' function. */
#undef HAVE_STRCHRNUL

/* Define to 1 if you have the `strdup' function. */
#undef HAVE_STRDUP

/* Define to 1 if you have the `strerror_r' function. */
#undef HAVE_STRERROR_R

/* Define to 1 if you have the <strings.h> header file. */
#undef HAVE_STRINGS_H

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H   1

/* Define to 1 if you have the `strncasecmp' function. */
#undef HAVE_STRNCASECMP

/* Define if you have the strndup() function and it works. */
#undef HAVE_STRNDUP

/* Define to 1 if you have the <stropts.h> header file. */
#undef HAVE_STROPTS_H

/* Define to 1 if you have the `strtoimax' function. */
#undef HAVE_STRTOIMAX

/* Define to 1 if you have the `strtol' function. */
#define HAVE_STRTOL  1

/* Define to 1 if you have the `strtoll' function. */
#undef HAVE_STRTOLL

/* Define to 1 if you have the `strtoul' function. */
#undef HAVE_STRTOUL

/* Define to 1 if you have the `strtoull' function. */
#undef HAVE_STRTOULL

/* Define to 1 if you have the `strtoumax' function. */
#undef HAVE_STRTOUMAX

/* Define to 1 if `st_atimensec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_ATIMENSEC

/* Define to 1 if `st_atimespec.tv_nsec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_ATIMESPEC_TV_NSEC

/* Define to 1 if `st_atim.st__tim.tv_nsec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_ATIM_ST__TIM_TV_NSEC

/* Define to 1 if `st_atim.tv_nsec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_ATIM_TV_NSEC

/* Define to 1 if `st_birthtimensec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BIRTHTIMENSEC

/* Define to 1 if `st_birthtimespec.tv_nsec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BIRTHTIMESPEC_TV_NSEC

/* Define to 1 if `st_birthtim.tv_nsec' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BIRTHTIM_TV_NSEC

/* Define to 1 if `st_blksize' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BLKSIZE

/* Define to 1 if `st_blocks' is member of `struct stat'. */
#undef HAVE_STRUCT_STAT_ST_BLOCKS

/* Define to 1 if `tm_zone' is member of `struct tm'. */
#undef HAVE_STRUCT_TM_TM_ZONE

/* Define if struct utimbuf is declared -- usually in <utime.h>. Some systems
   have utime.h but don't declare the struct anywhere. */
#define HAVE_STRUCT_UTIMBUF   1

/* Define to 1 if your `struct stat' has `st_blksize'. Deprecated, use
   `HAVE_STRUCT_STAT_ST_BLKSIZE' instead. */
#undef HAVE_ST_BLKSIZE

/* Define to 1 if your `struct stat' has `st_blocks'. Deprecated, use
   `HAVE_STRUCT_STAT_ST_BLOCKS' instead. */
#undef HAVE_ST_BLOCKS

/* Define if struct stat has a char st_fstype[] member. */
#undef HAVE_ST_FSTYPE_STRING

/* Define to 1 if you have the `symlink' function. */
#undef HAVE_SYMLINK

/* Define to 1 if you have the <sysexits.h> header file. */
#undef HAVE_SYSEXITS_H

/* Define to 1 if you have the <sys/bitypes.h> header file. */
#undef HAVE_SYS_BITYPES_H

/* Define to 1 if you have the <sys/buf.h> header file. */
#undef HAVE_SYS_BUF_H

/* Define to 1 if you have the <sys/device.h> header file. */
#undef HAVE_SYS_DEVICE_H

/* Define to 1 if you have the <sys/dir.h> header file, and it defines `DIR'.
   */
#undef HAVE_SYS_DIR_H

/* Define to 1 if you have the <sys/filio.h> header file. */
#undef HAVE_SYS_FILIO_H

/* Define to 1 if you have the <sys/gentape.h> header file. */
#undef HAVE_SYS_GENTAPE_H

/* Define to 1 if you have the <sys/inet.h> header file. */
#undef HAVE_SYS_INET_H

/* Define to 1 if you have the <sys/inttypes.h> header file. */
#undef HAVE_SYS_INTTYPES_H

/* Define to 1 if you have the <sys/io/trioctl.h> header file. */
#undef HAVE_SYS_IO_TRIOCTL_H

/* Define to 1 if you have the <sys/mtio.h> header file. */
#undef HAVE_SYS_MTIO_H

/* Define to 1 if you have the <sys/ndir.h> header file, and it defines `DIR'.
   */
#undef HAVE_SYS_NDIR_H

/* Define to 1 if you have the <sys/param.h> header file. */
#undef HAVE_SYS_PARAM_H

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/tape.h> header file. */
#undef HAVE_SYS_TAPE_H

/* Define to 1 if you have the <sys/timeb.h> header file. */
#undef HAVE_SYS_TIMEB_H

/* Define to 1 if you have the <sys/time.h> header file. */
#undef HAVE_SYS_TIME_H

/* Define to 1 if you have the <sys/tprintf.h> header file. */
#undef HAVE_SYS_TPRINTF_H

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H   1

/* Define to 1 if you have the <sys/wait.h> header file. */
#undef HAVE_SYS_WAIT_H

/* Define to 1 if you have the <time.h> header file. */
#define HAVE_TIME_H  1

/* Define if struct tm has the tm_gmtoff member. */
#undef HAVE_TM_GMTOFF

/* Define to 1 if your `struct tm' has `tm_zone'. Deprecated, use
   `HAVE_STRUCT_TM_TM_ZONE' instead. */
#undef HAVE_TM_ZONE

/* Define to 1 if you have the `tsearch' function. */
#undef HAVE_TSEARCH

/* Define to 1 if you don't have `tm_zone' but do have the external array
   `tzname'. */
#undef HAVE_TZNAME

/* Define to 1 if you have the <unistd.h> header file. */
#undef HAVE_UNISTD_H

/* Define to 1 if you have the `unsetenv' function. */
#undef HAVE_UNSETENV

/* Define to 1 if the system has the type `unsigned long long int'. */
#undef HAVE_UNSIGNED_LONG_LONG_INT

/* Define to 1 if you have the `utimes' function. */
#undef HAVE_UTIMES

/* Define if utimes accepts a null argument */
#undef HAVE_UTIMES_NULL

/* Define to 1 if you have the <utime.h> header file. */
#undef HAVE_UTIME_H

/* Define to 1 if `utime(file, NULL)' sets file's timestamp to the present. */
#undef HAVE_UTIME_NULL

/* Define to 1 if you have the `vasnprintf' function. */
#define HAVE_VASNPRINTF 1

/* Define to 1 if you have the `vsnprintf' function. */
#define HAVE_VSNPRINTF  1

/* Define to 1 if you have the `waitpid' function. */
#undef HAVE_WAITPID

/* Define to 1 if you have the <wchar.h> header file. */
#define HAVE_WCHAR_H 1

/* Define if you have the 'wchar_t' type. */
#define HAVE_WCHAR_T 1

/* Define to 1 if you have the `wcrtomb' function. */
#undef HAVE_WCRTOMB

/* Define to 1 if you have the `wcscoll' function. */
#undef HAVE_WCSCOLL

/* Define to 1 if you have the `wcslen' function. */
#define HAVE_WCSLEN  1

/* Define to 1 if you have the <wctype.h> header file. */
#undef HAVE_WCTYPE_H

/* Define to 1 if you have the `wcwidth' function. */
#undef HAVE_WCWIDTH

/* Define if you have the 'wint_t' type. */
#undef HAVE_WINT_T

/* Define to 1 if you have the `wmemchr' function. */
#undef HAVE_WMEMCHR

/* Define to 1 if you have the `wmemcpy' function. */
#undef HAVE_WMEMCPY

/* Define to 1 if you have the `wmempcpy' function. */
#undef HAVE_WMEMPCPY

/* Define to 1 if O_NOATIME works. */
#undef HAVE_WORKING_O_NOATIME

/* Define to 1 if O_NOFOLLOW works. */
#undef HAVE_WORKING_O_NOFOLLOW

/* Define if utimes works properly. */
#undef HAVE_WORKING_UTIMES

/* Define to 1 if the system has the type `_Bool'. */
#undef HAVE__BOOL

/* Define to 1 if you have the `_ftime' function. */
#undef HAVE__FTIME

/* Define to 1 if you have the `__fpending' function. */
#undef HAVE___FPENDING

/* Define as const if the declaration of iconv() needs const. */
#undef ICONV_CONST

#if FILE_SYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR
# define ISSLASH(C) ((C) == '/' || (C) == '\\')
#else
# define ISSLASH(C) ((C) == '/')
#endif

/* Define to 1 if `lstat' dereferences a symlink specified with a trailing
   slash. */
#undef LSTAT_FOLLOWS_SLASHED_SYMLINK

/* Define to 1 if `major', `minor', and `makedev' are declared in <mkdev.h>.
   */
#undef MAJOR_IN_MKDEV

/* Define to 1 if `major', `minor', and `makedev' are declared in
   <sysmacros.h>. */
#undef MAJOR_IN_SYSMACROS

/* If malloc(0) is != NULL, define this to 1. Otherwise define this to 0. */
#define MALLOC_0_IS_NONNULL   1

/* Define to mt_model (v.g., for DG/UX), else to mt_type. */
#undef MTIO_CHECK_FIELD

/* Define to 1 if your C compiler doesn't accept -c and -o together. */
#undef NO_MINUS_C_MINUS_O

/* Name of package */
#define PACKAGE   "tar"

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT  "ubuntu@geoffair.info"

/* Define to the full name of this package. */
#define PACKAGE_NAME "tar port for Win32"

/* Define to the full name and version of this package. */
#define PACKAGE_STRING   PACKAGE_NAME "1.21.03"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "tar"

/* Define to the version of this package. */
#define PACKAGE_VERSION "1.21.03"

/* the number of pending output bytes on stream `fp' */
#define PENDING_OUTPUT_N_BYTES   256

/* Define if <inttypes.h> exists and defines unusable PRI* macros. */
#undef PRI_MACROS_BROKEN

/* Define to l, ll, u, ul, ull, etc., as suitable for constants of type
   'ptrdiff_t'. */
#define PTRDIFF_T_SUFFIX

/* Define to the full path of your rsh, if any. */
#undef REMOTE_SHELL

/* Define this to 1 if strerror is broken. */
#undef REPLACE_STRERROR

/* Define if vasnprintf exists but is overridden by gnulib. */
#undef REPLACE_VASNPRINTF

/* Define as the return type of signal handlers (`int' or `void'). */
#define RETSIGTYPE   int

/* Define to l, ll, u, ul, ull, etc., as suitable for constants of type
   'sig_atomic_t'. */
#define SIG_ATOMIC_T_SUFFIX

/* Define as the maximum value of type 'size_t', if the system doesn't define
   it. */
// #undef SIZE_MAX

/* Define to l, ll, u, ul, ull, etc., as suitable for constants of type
   'size_t'. */
#define SIZE_T_SUFFIX   LL

/* If using the C implementation of alloca, define if you know the
   direction of stack growth for your system; otherwise it will be
   automatically deduced at runtime.
	STACK_DIRECTION > 0 => grows toward higher addresses
	STACK_DIRECTION < 0 => grows toward lower addresses
	STACK_DIRECTION = 0 => direction of growth unknown */
#undef STACK_DIRECTION

/* Define to 1 if the `S_IS*' macros in <sys/stat.h> do not work properly. */
#undef STAT_MACROS_BROKEN

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Define to 1 if strerror_r returns char *. */
#undef STRERROR_R_CHAR_P

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
#undef TIME_WITH_SYS_TIME

/* Define to 1 if your <sys/time.h> declares `struct tm'. */
#undef TM_IN_SYS_TIME

/* Define to 1 if the type of the st_atim member of a struct stat is struct
   timespec. */
#undef TYPEOF_STRUCT_STAT_ST_ATIM_IS_STRUCT_TIMESPEC

/* Define to 1 if unlink (dir) cannot possibly succeed. */
#define UNLINK_CANNOT_UNLINK_DIR 1

/* Define to 1 if you want getc etc. to use unlocked I/O if available.
   Unlocked I/O can improve performance in unithreaded apps, but it is not
   safe for multithreaded apps. */
#undef USE_UNLOCKED_IO

/* Version number of package */
#define  VERSION  "1.21.02"

/* Define if unsetenv() returns void, not int. */
#undef VOID_UNSETENV

/* Define to l, ll, u, ul, ull, etc., as suitable for constants of type
   'wchar_t'. */
#define WCHAR_T_SUFFIX

/* Define to l, ll, u, ul, ull, etc., as suitable for constants of type
   'wint_t'. */
#define WINT_T_SUFFIX

/* Number of bits in a file offset, on hosts where this is settable. */
#undef _FILE_OFFSET_BITS

/* Enable GNU extensions on systems that have them.  */
#ifndef _GNU_SOURCE
# undef _GNU_SOURCE
#endif

/* Define for large files, on AIX-style hosts. */
#undef _LARGE_FILES

/* Define to 1 if on MINIX. */
#undef _MINIX

/* Define to 2 if the system does not provide POSIX.1 features except with
   this defined. */
#undef _POSIX_1_SOURCE

/* Define to 1 if you need to in order for `stat' and other things to work. */
#undef _POSIX_SOURCE

/* Define if you want regoff_t to be at least as wide POSIX requires. */
#undef _REGEX_LARGE_OFFSETS

/* Enable extensions on AIX 3, Interix.  */
#ifndef _ALL_SOURCE
# undef _ALL_SOURCE
#endif
/* Enable GNU extensions on systems that have them.  */
#ifndef _GNU_SOURCE
# undef _GNU_SOURCE
#endif
/* Enable threading extensions on Solaris.  */
#ifndef _POSIX_PTHREAD_SEMANTICS
# undef _POSIX_PTHREAD_SEMANTICS
#endif
/* Enable extensions on HP NonStop.  */
#ifndef _TANDEM_SOURCE
# undef _TANDEM_SOURCE
#endif
/* Enable general extensions on Solaris.  */
#ifndef __EXTENSIONS__
# undef __EXTENSIONS__
#endif


/* Define to rpl_ if the getopt replacement functions and variables should be
   used. */
#undef __GETOPT_PREFIX

/* Define to rpl_ if the openat replacement function should be used. */
#define __OPENAT_PREFIX rpl_

/* Ensure that <stdint.h> defines the limit macros, since gnulib's
   <inttypes.h> relies on them.  */
#if defined __cplusplus && !defined __STDC_LIMIT_MACROS && GL_TRIGGER_STDC_LIMIT_MACROS
# define __STDC_LIMIT_MACROS 1
#else
#ifndef __STDC_LIMIT_MACROS
# define __STDC_LIMIT_MACROS 1
#endif
#endif

/* Define to `unsigned' if <sys/types.h> does not define. */
#undef dev_t

/* Define to rpl_fchownat if the replacement function should be used. */
#undef fchownat

/* Define to a replacement function name for fnmatch(). */
#undef fnmatch

/* Define to `int' if <sys/types.h> doesn't define. */
#define gid_t  short

/* A replacement for va_copy, if needed.  */
#define gl_va_copy(a,b) ((a) = (b))

/* Define to rpl_gmtime if the replacement function should be used. */
#undef gmtime

/* Conversion descriptor type */
#define iconv_t   int

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
#define  inline   __inline
#endif

/* Define to `unsigned' if <sys/types.h> does not define. */
#undef ino_t

/* Define to long or long long if <stdint.h> and <inttypes.h> don't define. */
#undef intmax_t

/* Define to rpl_localtime if the replacement function should be used. */
#undef localtime

/* Type of major device numbers. */
#define major_t   int

/* Define to rpl_malloc if the replacement function should be used. */
// #undef malloc

/* Define to a type if <wchar.h> does not define. */
#undef mbstate_t

/* Type of minor device numbers. */
#define minor_t   int

/* Define to rpl_mktime if the replacement function should be used. */
#undef mktime

/* Define to `int' if <sys/types.h> does not define. */
#define mode_t int

/* Define to `long int' if <sys/types.h> does not define.
   #undef off_t - can NOT define this, but do NEED some 64-bit items */
typedef __int64 off64_t;
typedef unsigned __int64 size64_t;
typedef __int64 ssize64_t;

/* Define to `int' if <sys/types.h> does not define. */
#define pid_t  int

/* Define to rpl_re_comp if the replacement should be used. */
#undef re_comp

/* Define to rpl_re_compile_fastmap if the replacement should be used. */
#undef re_compile_fastmap

/* Define to rpl_re_compile_pattern if the replacement should be used. */
#undef re_compile_pattern

/* Define to rpl_re_exec if the replacement should be used. */
#undef re_exec

/* Define to rpl_re_match if the replacement should be used. */
#undef re_match

/* Define to rpl_re_match_2 if the replacement should be used. */
#undef re_match_2

/* Define to rpl_re_search if the replacement should be used. */
#undef re_search

/* Define to rpl_re_search_2 if the replacement should be used. */
#undef re_search_2

/* Define to rpl_re_set_registers if the replacement should be used. */
#undef re_set_registers

/* Define to rpl_re_set_syntax if the replacement should be used. */
#undef re_set_syntax

/* Define to rpl_re_syntax_options if the replacement should be used. */
#undef re_syntax_options

/* Define to a replacement function name for realpath(). */
#undef realpath

/* Define to rpl_regcomp if the replacement should be used. */
#undef regcomp

/* Define to rpl_regerror if the replacement should be used. */
#undef regerror

/* Define to rpl_regexec if the replacement should be used. */
#undef regexec

/* Define to rpl_regfree if the replacement should be used. */
#undef regfree

/* Define to the equivalent of the C99 'restrict' keyword, or to
   nothing if this is not supported.  Do not define if restrict is
   supported directly.  */
#define restrict
/* Work around a bug in Sun C++: it does not support _Restrict, even
   though the corresponding Sun C compiler does, which causes
   "#define restrict _Restrict" in the previous line.  Perhaps some future
   version of Sun C++ will work with _Restrict; if so, it'll probably
   define __RESTRICT, just as Sun C does.  */
#if defined __SUNPRO_CC && !defined __RESTRICT
# define _Restrict
#endif

/* Define to `unsigned int' if <sys/types.h> does not define. */
/* #undef size_t */

/* Define as a signed type of the same size as size_t. */
typedef int ssize_t;

/* Define to rpl_strnlen if the replacement function should be used. */
#undef strnlen

/* Define to `int' if <sys/types.h> doesn't define. */
#define uid_t  short

/* Define to rpl_utime if the replacement function should be used. */
#undef utime

/* Define as a macro for copying va_list variables. */
#define va_copy(a,b) a = b

#define  HAVE_STDBOOL_H 0
#ifndef bool
typedef char bool;
#endif
#ifndef false
#define  false 0
#endif
#ifndef true
#define true 1
#endif

#pragma warning(disable:4996) /* This function or variable may be unsafe ... */

/* also suppress, for the moment 
   *** THESE SHOULD NOT STAY OFF!!! ***
   only turned off to see what others there are ... */
#pragma warning(disable:4018) /* '<' : signed/unsigned mismatch */
#pragma warning(disable:4244) /* conversion from 'unsigned __int64' to '_off_t', possible loss of data */
#pragma warning(disable:4146) /* unary minus operator applied to unsigned type, result still unsigned */
#pragma warning(disable:4090) /* C4090: 'function' : different 'const' qualifiers */
#pragma warning(disable:4101) /* C4101: 'buf' : unreferenced local variable */
#pragma warning(disable:4305) /* C4305: 'initializing' : truncation from 'double' to 'float' */

/* some I have done dome work to clean up by patching the code */
//#pragma warning(disable:4013) /* C4013: some 'function' undefined; assuming extern returning int */

/* main includes */
#define  NOGDI    /* exclude, since redefine of 'ERROR' */
#define  NOMINMAX /* aready defind in source */

/* in limits.h - set max bits
   NOTE: This MAY cause problems since not all parts of the code
   are fully 64-bit compatible - but give it a try ;=)) */
#define  _INTEGRAL_MAX_BITS   64
#undef  _POSIX_  /* this causes BIG PROBLEMS if ON */

/* move into the 64-bit range */
#ifdef   USE_64BIT_OFFSET_TYPE
#ifndef _OFF_T_DEFINED
typedef __int64 _off_t;                    /* file offset value */
#if     !__STDC__
/* Non-ANSI name for compatibility */
typedef __int64 off_t;
#endif
#define _OFF_T_DEFINED
#endif
#endif /* USE_64BIT_OFFSET_TYPE */

#ifndef _WIN32_WINNT
/* needed for things like DeviceIoControl(fd, FSCTL_SET_SPARSE, ... ), etc */
#define _WIN32_WINNT		0x0500		// Windows 2000 or later
#endif

#include <windows.h>
/* other system includes - if not already in!!! */
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <io.h>         // for _chmod(), _setmode(), etc
#include <malloc.h>     // malloc() and free()
#include <direct.h>     // mkdir(), chdir(), rmdir(), getcwd()
#include <sys/stat.h>   // struct stat and stat()
#include <sys/utime.h>  // for utime() - set file times
#include <errno.h>      // for E2BIG = EOVERFLOW
#include <process.h>    // for spawnl(), and _P_WAIT ...
#include <wchar.h>      // for mbrtowc()
#include <memory.h>     // for memchr
#include <string.h>     // for memchr
#include <time.h>       // for _get_tzname
#include <limits.h>     // for TZNAME_MAX, but only if _POSIX_, which causes other
//                         problems, so is defined below ...

/* local includes */
#include "winport.h"    // supply 'missing' services
#include "windebug.h"   // get last windows error
#include "win_time.h"   // to define timespec

#ifndef PATH_MAX  /* defined in limits.h, under _POSIX_, but causes too many other probs */
#define  PATH_MAX    MAX_PATH
#endif

#ifndef F_OK
#define F_OK   0
#endif /* !F_OK */

#ifndef P_WAIT
#define P_WAIT _P_WAIT
#endif

#ifndef TZNAME_MAX
#define TZNAME_MAX          10
#endif

#define WIN_INT32_MAX 0x7fffffff
#define WIN_INT32_MIN (-WIN_INT32_MAX - 1)
#define WIN_INT64_MAX 0x7fffffffffffffffll
#define WIN_INT64_MIN (-WIN_INT64_MAX - 1)

// # define UINTMAX_MAX (__UINT64_C(18446744073709551615))]
#ifndef UINTMAX_MAX
#define  UINTMAX_MAX 0xffffffff
#endif
#ifndef uintmax_t
typedef unsigned int uintmax_t;
#endif
#ifndef intmax_t
typedef int intmax_t;
#endif

/* use 64-bit seek and stat */
#define struct_stat struct __stat64
#define  FDSEEK   _lseeki64
#define  FNSTAT   _stat64
#define  FDSTAT   _fstat64

#ifndef inttype
typedef  int   inttype;
#endif
#ifndef uint32_t
typedef unsigned int uint32_t;
#endif

//#ifndef timespec
//#ifndef HAVE_STRUCT_TIMESPEC
//#define HAVE_STRUCT_TIMESPEC 1
//typedef __time_t time_t;
/* POSIX.1b structure for a time value.  This is like a `struct timeval' but
   has nanoseconds instead of microseconds.  */
//struct timespec {
//    time_t tv_sec;		/* Seconds.  */
//    long int tv_nsec;		/* Nanoseconds.  */
//  };
//#endif
//#endif

/* from linux stat.h
#if defined(__KERNEL__) || !defined(__GLIBC__) || (__GLIBC__ < 2)
#define S_IFMT  00170000

#define S_IFSOCK 0140000
#define S_IFLNK  0120000
#define S_IFREG  0100000
#define S_IFBLK  0060000
#define S_IFDIR  0040000
#define S_IFCHR  0020000
#define S_IFIFO  0010000
#define S_ISUID  0004000
#define S_ISGID  0002000
#define S_ISVTX  0001000

#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#define S_ISSOCK(m)	(((m) & S_IFMT) == S_IFSOCK)

#define S_IRWXU 00700
#define S_IRUSR 00400
#define S_IWUSR 00200
#define S_IXUSR 00100
#define S_IRWXG 00070
#define S_IRGRP 00040
#define S_IWGRP 00020
#define S_IXGRP 00010
#define S_IRWXO 00007
#define S_IROTH 00004
#define S_IWOTH 00002
#define S_IXOTH 00001
#endif
 *************************** */
// from sys/stat.h
//#define _S_IFMT         0xF000          /* file type mask */
//#define _S_IFDIR        0x4000          /* directory */
//#define _S_IFCHR        0x2000          /* character special */
//#define _S_IFIFO        0x1000          /* pipe */
//#define _S_IFREG        0x8000          /* regular */
//#define _S_IREAD        0x0100          /* read permission, owner */
//#define _S_IWRITE       0x0080          /* write permission, owner */
//#define _S_IEXEC        0x0040          /* execute/search permission, owner */

#define  S_ISLNK(m)	0
#define  S_ISREG(m)	(((m) & _S_IFMT) == _S_IFREG)
#define  S_ISDIR(m)  (((m) & _S_IFMT) == _S_IFDIR)
#define  S_ISCHR(m)	(((m) & _S_IFMT) == _S_IFCHR)
#define  S_ISBLK(m)	0
#define  S_ISFIFO(m)	(((m) & _S_IFMT) == _S_IFIFO)
#define  S_ISSOCK(m)	0

#define S_IFSOCK 0
#define S_IFLNK  0
//#define S_IFREG  0100000
#define S_IFBLK  0
//#define S_IFDIR  0040000
//#define S_IFCHR  0020000
//#define S_IFIFO  0010000
#define S_ISUID  0
#define S_ISGID  0
#define S_ISVTX  0

#define S_IRUSR _S_IREAD
#define S_IRGRP S_IRUSR
#define S_IROTH S_IRUSR

#define S_IWUSR _S_IWRITE
#define S_IWGRP S_IWUSR
#define S_IWOTH S_IWUSR

#define S_IXUSR _S_IEXEC
#define S_IXGRP S_IXUSR
#define S_IXOTH S_IXUSR
#define S_IXUGO S_IXUSR

#define S_IRWXU (_S_IREAD | _S_IWRITE | _S_IEXEC)
#define S_IRWXG S_IRWXU
#define S_IRWXO S_IRWXU

#define  S_IRWXUGO   S_IRWXU

/* define to 1 if sys/file.h available */
#undef   HAVE_SYSFILE_H
#undef   HAVE_RMT_COMMAND_H

#ifndef PRIuMAX
#   define PRIuMAX "lu"
#endif

#define  getgid   GetCurrentProcessId
#define  getuid   GetCurrentProcessId

#define  lstat __stat64
#define  freea free

#ifndef HAVE_GETPAGESIZE
#define getpagesize() 4096
#endif

#define O_DIRECTORY  0
#define O_NOCTTY     0
#define O_NONBLOCK   0

#undef  NEW_DELETE_FUNCTION   /* OFF, until FIXED for EXTENDED headers */

#include "protos.h"

#endif /* _WIN32_CONFIG_H_ */
/* eof - config.h */
