
@REM # Tar 1.15.1 incorrectly computed sparse member size if the extended
@REM # PAX header contained size keyword.
@REM # References: <87vf46nb36.fsf@penguin.cs.ucla.edu>
@REM # http://lists.gnu.org/archive/html/bug-tar/2005-06/msg00040.html

@REM Problem in WIN32 - extraction of sparse file, does not produce a sparse file!!!
@REM This may be due to using lowlevel IO, instead of native WIN32 IO, or ??????
@REM Had ot make this change in genfile earlier ...

@set TEMPPR=%PROMPT%
@if NOT EXIST setup.bat goto ERR1
call setup
call mdd temp
@if NOT EXIST ..\volume.bat goto ERR2
@set PROMPT=# 

genfile --length 1000 --file begin
genfile --length 1000 --file end
genfile --sparse --file sparsefile --block-size 512 8G A
@if ERRORLEVEL 1 goto ERR4
@if NOT EXIST sparsefile goto ERR3

%TEMPT% -c -f archive --format=posix --sparse begin sparsefile end
@if ERRORLEVEL 1 goto ERR5
@echo separator

%TEMPT% tfv archive
@echo separator
md directory
%TEMPT% vvvvvvCxf directory archive
genfile --stat=name,size sparsefile
genfile --stat=name,size directory/sparsefile

@%TEMPC% sparsefile directory/sparsefile -b

@cd ..
@goto END

:ERR1
@echo Can NOT locate setup.bat ... check name, location ...
@goto END

:ERR2
@echo mdd.bat missing, or failed ... check name, location ...
@goto END

:ERR3
@echo ERROR: Failed to create sparsefile ... maybe genfile is NOT in PATH ..
@goto WAIT

:ERR4
@echo ERROR: Got errorlevel when generating sparsefile ... maybe genfile is NOT in PATH ..
@goto WAIT

:WAIT
cd ..
@set PROMPT=%TEMPPR%
@pause
@goto END

:END
@set PROMPT=%TEMPPR%

