
// windebug.c

// just some DEBUG stuff

#include <config.h>
#include <system.h>
#include <common.h>
#include <lmerr.h>   /* for NERR_BASE, ... */

DWORD dw_winLastError = 0;
static HANDLE hOutFile = NULL;
void win_Create_Log_File( void )
{
   hOutFile = CreateFile(DEF_LOG_FILE,
      GENERIC_WRITE,
      FILE_SHARE_READ,
      NULL,
      CREATE_ALWAYS,
      FILE_ATTRIBUTE_NORMAL,
      NULL);
}

HANDLE win_GetOutHandle( void ) { return hOutFile; }

char * GetWinErrorText( char * lpszBuf, DWORD dwSize, DWORD dwError ) 
{
   LPSTR MessageBuffer;
   DWORD dwBufferLength;
   DWORD dwFormatFlags = FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_IGNORE_INSERTS |
        FORMAT_MESSAGE_FROM_SYSTEM ;
   HMODULE hModule = NULL; // default to system source

   dw_winLastError = dwError;
   sprintf(lpszBuf, "Error %d", dwError );
   if(dwError >= NERR_BASE && dwError <= MAX_NERR)
   {
      hModule = LoadLibraryEx( TEXT("netmsg.dll"),
         NULL,
         LOAD_LIBRARY_AS_DATAFILE );

      if(hModule != NULL)
         dwFormatFlags |= FORMAT_MESSAGE_FROM_HMODULE;
   }

   // Call FormatMessage() to allow for message 
   //  text to be acquired from the system 
   //  or from the supplied module handle.

   if( dwBufferLength = FormatMessageA (
      dwFormatFlags,
      hModule, // module to get message from (NULL == system)
      dwError,
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // default language
      (LPSTR) &MessageBuffer,
      0,
      NULL ))
   {
      if( dwBufferLength > dwSize )
      {
         strncpy( lpszBuf, MessageBuffer, dwSize - 1 );
         strcpy( &lpszBuf[dwSize - 4], "...");
      }
      else
         strcpy( lpszBuf, MessageBuffer );

      // Free the buffer allocated by the system.
      LocalFree(MessageBuffer);
   }
   return lpszBuf;
}


char * GetLastErrorText( char * lpszBuf, DWORD dwSize ) 
{
   dw_winLastError = GetLastError();
   return GetWinErrorText( lpszBuf, dwSize, dw_winLastError );
}

char * GetWinError( DWORD dwError )
{
   static char _s_winerror[264];
   return GetWinErrorText( _s_winerror, sizeof( _s_winerror), dwError );
}

void win_debug_read( size_t status, int archive, char * buffer )
{
  static int _s_read_cnt = 0;
  _s_read_cnt++;
  if( status >= 0 )
  {
#ifdef NEW_DELETE_FUNCTION
      extern __int64 dbg_roffset;
      fprintf( stderr, "\n%d: Read %d bytes into buffer %X, from %d fd (from off %#I64X - %#I64X)\n",
         _s_read_cnt, status, buffer, archive,
         dbg_roffset, (dbg_roffset + status) );
#ifdef HEAVY_DEBUG_DELETE
         print_hex( buffer, status, "in", dbg_roffset );
#endif /* HEAVY_DEBUG_DELETE */
      dbg_roffset += status;
#else /* !NEW_DELETE_FUNCTION */
      fprintf( stderr, "\n%d: Read %d bytes into buffer %X, from %d fd\n",
         _s_read_cnt, status, buffer, archive );
#endif /* NEW_DELETE_FUNCTION y/n */
  }
  else
  {
#ifdef NEW_DELETE_FUNCTION
      fprintf( stderr, "\n%d: FAILED read, from %d fd, errno = %d (from off %#I64X)\n",
         _s_read_cnt, archive, errno,
         dbg_roffset );
#else /* !NEW_DELETE_FUNCTION */
      fprintf( stderr, "\n%d: FAILED read, from %d fd, errno = %d\n",
         _s_read_cnt, archive, errno );
#endif /* NEW_DELETE_FUNCTION y/n */
  }
}

// eof - windebug.c
