// winport.h
#ifndef _winport_h_
#define _winport_h_

/* some GLUE code, just for WIN32 */
#define  DT_DIR      1

struct dirent{
	int  d_namlen;
   unsigned short d_reclen;
	unsigned char d_type;
	char d_name[256];
};

struct _DIR {
	HANDLE hfind;
	WIN32_FIND_DATA fd;
	char search[264];
	struct dirent de;
	int	is_first;
};

typedef struct _DIR DIR;

extern DIR * opendir(const char * dir );
extern struct dirent * readdir(DIR * dp);
extern int closedir(DIR * dp);

/* allow -@input.fil command input */
extern void input_response_file (int *pargc, char ***pargv);
extern void term_response_file( void );

struct timezone 
{
  int  tz_minuteswest; /* minutes W of Greenwich */
  int  tz_dsttime;     /* type of dst correction */
};
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int geteuid( void );   /* not really! return 0 to signal root!! */

/* sparse file support */
extern int win_drive_supports_sparse( char * pfile );
extern int win_is_sparse_file( char * pfile );
extern __int64 win_get_sparse_file_size( char * pfile );
extern int win_verify_sparse( char * pfile, struct __stat64 * pst );

/* do it the windows way */
extern char * win_truncate_file( char * name, __int64 size );

/* common exit */
extern void win_exit( int val );
#if !defined(WIN64)
/* this will go away in WIN64 */
extern void too_large_for_win32_die (void);
#endif

extern int win_set_sparse_attribute_on_descriptor( char * name, int fd );
extern int win_set_sparse_attribute( char * name, long h );

#endif // _winport_h_
// eof - winport.h
